<?php

es_include("modulehandler.php");

class SitemapHandler extends ModuleHandler
{
	function ProcessPublic()
	{
		$this->header["InsideModule"] = $this->module;
		if ($this->IsMainHTML())
		{
			$publicPage = new PublicPage($this->module);
			$content = $publicPage->Load($this->tmplPrefix."main.html", $this->header, $this->pageID);
			$content->SetVar("Title", $this->header["Title"]);
			$content->SetLoop("Navigation", $this->header["Navigation"]);

			$pageList = new PageList();

			if ($this->config['ViewAs'] == "list")
			{
				$list = $pageList->GetPageTree($this->pageID, true);
				foreach ($list as $k => $v)
				{
					if ($list[$k]["Path2Root"] == "#")
						unset($list[$k]);
				}
				$list = MultiSort($list, "Title", true, 4);
				$content->SetVar("SiteMap", $this->GetMapAsList($list));
			}
			else
			{
				$tree = $pageList->GetPageTree($this->pageID, false);
				$result = array();
				foreach ($tree["full"] as $menu)
				{
					if (isset($menu["Children"]) && is_array($menu["Children"]))
					{
						// Exclude top level pages from tree
						$result = array_merge($result, $menu["Children"]);
					}
				}
				$content->SetVar("SiteMap", $this->GetMapAsTree($result));
			}

			for ($i = 1; $i < $this->header['MenuImageCount'] + 1; $i++)
			{
				$content->SetVar('MenuImage'.$i, $this->header['MenuImage'.$i]);
				$content->SetVar('MenuImage'.$i.'Path', $this->header['MenuImage'.$i.'Path']);
			}

			$content->SetVar('PageID', $this->pageID);
			$content->SetVar('PageTitle', $this->header['Title']);
			$content->SetVar('PageDescription', $this->header['Description']);
			$content->SetVar('PageContent', $this->content);

			$publicPage->Output($content);
		}
		else if ($this->IsMainXML())
		{
			header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
			header("Last-Modified: ".gmdate("D, d M Y H:i:s")."GMT");
			header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
			header("Pragma: no-cache"); // HTTP/1.0

			$pageList = new PageList();
			$list = $pageList->GetPageTree($this->pageID, true);

			foreach ($list as $k => $v)
			{
				if ($list[$k]["Path2Root"] == "#")
					unset($list[$k]);
			}
			$list = MultiSort($list, "Level", true, 2);

			echo '<?xml version="1.0" encoding="UTF-8" ?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd">
';

			$module = new Module();

			foreach ($list as $k => $v)
			{
				if ($v['Type'] == 3)
					continue;

				$priority = GetPriority($v['Level']);

				// Calculate timezone offset (in PHP4 'c' doesn't work in date() function)
				$timeZoneOffset = date("Z", strtotime($v['LastModified']));
				$t1 = intval($timeZoneOffset/3600);
				$t2 = abs($timeZoneOffset%3600/60);
				if ($timeZoneOffset > 0)
					$offset = sprintf("+%02d:%02d", $t1, $t2);
				else
					$offset = sprintf("%03d:%02d", $t1, $t2);

				$lastModified = date("Y-m-d\TH:i:s", strtotime($v['LastModified'])).$offset;
				echo '<url>
	<loc>http://'.$_SERVER['HTTP_HOST'].$v['PageURL'].'</loc>
	<priority>'.sprintf("%01.2f", $priority).'</priority>
	<lastmod>'.$lastModified.'</lastmod>
	<changefreq>weekly</changefreq>
</url>
';
				if ($v['Type'] == 2 && $v['Link'] != $this->module)
				{
					$path = substr($v['PageURL'], strlen(PROJECT_PATH));
					$pathToModule = explode(".", $path);
					array_pop($pathToModule);

					$data = $module->LoadModuleMap($v['Link'], $v['Template'], $pathToModule, $v['PageID'], $pageList->GetConfig($v['Link'], $v['Config']), $v['Level'] + 1);
					for ($i = 0; $i < count($data); $i++)
					{
						if ($data[$i]['LastModified'])
							$lastModified = date("Y-m-d\TH:i:s", strtotime($data[$i]['LastModified'])).$offset;
						echo '<url>
	<loc>'.$data[$i]['PageURL'].'</loc>
	<priority>'.sprintf("%01.2f", $data[$i]['Priority']).'</priority>
	<lastmod>'.$lastModified.'</lastmod>
	<changefreq>weekly</changefreq>
</url>
';
					}
				}
			}
			echo '</urlset>';
		}
		else
		{
			Send404();
		}
	}

	function GetMapAsTree($tree)
	{
		$output = "<ul>";
		foreach ($tree as $node)
		{
			// Do not include links
			if (!$this->config['IncludeLinks'] && $node['Type'] == 3)
				continue;

			$output .= "<li><a href=\"".$node["PageURL"]."\">".$node["Title"]."</a>";
			if (isset($node["Children"]) && count($node["Children"]))
			{
				$output .= $this->GetMapAsTree($node["Children"]);
			}
			$output .= "</li>";
		}
		if ($output == "<ul>")
			$output = "";
		else
			$output .= "</ul>";
		return $output;
	}

	function GetMapAsList($list)
	{
		$output = "<ul>\r\n";
		$prevFirstChar = "";
		$firtElm = true;
		foreach ($list as $node)
		{
			// Do not include links
			if (!$this->config['IncludeLinks'] && $node['Type'] == 3)
				continue;

			if ($prevFirstChar != $node["FirstChar"])
			{
				$prevFirstChar = $node["FirstChar"];
				if ($firtElm)
					$output .= "<li><b>".$prevFirstChar."</b></li>\r\n\t<ul>\r\n";
				else
					$output .= "\t</ul>\r\n<li><b>".$prevFirstChar."</b></li>\r\n\t<ul>\r\n";
			}
			$output .= "\t\t<li><a href='".$node["PageURL"]."'>".$node["Title"]."</a></li>\r\n";
			$firtElm = false;
		}
		$output .= "\t</ul>\r\n</ul>";
		return $output;
	}
}

?>