<?php

es_include("modulehandler.php");
es_include("pagelist.php");
es_include("page.php");

class SearchHandler extends ModuleHandler
{
	function ProcessPublic()
	{
		$this->header["InsideModule"] = $this->module;
		if ($this->IsMainHTML())
		{
			if (substr($_SERVER['HTTP_HOST'], 0, 9) == 'localhost' || GetFromConfig('DevMode'))
				$googleCSEXML = "http://eurostudio.net/cref_cse.xml";
			else
				$googleCSEXML = "http://".$_SERVER['HTTP_HOST'].$this->baseURL.".xml";

			$request = new LocalObject(array_merge($_GET, $_POST));

			$publicPage = new PublicPage($this->module);
			$content = $publicPage->Load($this->tmplPrefix."main.html", $this->header, $this->pageID);

			$content->SetVar("Title", $this->header["Title"]);
			$content->SetLoop("Navigation", $this->header["Navigation"]);
			$content->SetVar('GoogleCSEXML', $googleCSEXML);
			$content->SetVar("SearchWord", $request->GetProperty("q"));

			for ($i = 1; $i < $this->header['MenuImageCount'] + 1; $i++)
			{
				$content->SetVar('MenuImage'.$i, $this->header['MenuImage'.$i]);
				$content->SetVar('MenuImage'.$i.'Path', $this->header['MenuImage'.$i.'Path']);
			}

			$content->SetVar('PageID', $this->pageID);
			$content->SetVar('PageTitle', $this->header['Title']);
			$content->SetVar('PageDescription', $this->header['Description']);
			$content->SetVar('PageContent', $this->content);

			$publicPage->Output($content);
		}
		else if ($this->IsMainXML())
		{
			header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
			header("Last-Modified: ".gmdate("D, d M Y H:i:s")."GMT");
			header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
			header("Pragma: no-cache"); // HTTP/1.0
			echo "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>
<GoogleCustomizations>
	<CustomSearchEngine>
		<Title>".$this->config['Title']."</Title>
		<Description>".$this->config['Description']."</Description>
		<Context>
			<BackgroundLabels>
				<Label name=\"example\" mode=\"FILTER\" />
			</BackgroundLabels>
		</Context>
		<LookAndFeel nonprofit=\"true\">
			<Logo url=\"http://www.ascii.com/logo.gif\" destination=\"http://www.ascii.com/\" height=\"90\" />
			<Colors url=\"".$this->config['ColorURL']."\" background=\"".$this->config['ColorBackground']."\" border=\"".$this->config['ColorBorder']."\" title=\"".$this->config['ColorTitle']."\" text=\"".$this->config['ColorText']."\" visited=\"".$this->config['ColorVisited']."\" light=\"".$this->config['ColorLight']."\" />
		</LookAndFeel>
	</CustomSearchEngine>
	<Annotations>
		<Annotation about=\"".$this->config['Website']."\">
			<Label name=\"example\" />
		</Annotation>
	</Annotations>
</GoogleCustomizations>";
		}
		else
		{
			Send404();
		}
	}

	function ProcessHeader($module)
	{
		$data = array();

		$pageList = new PageList();
		$pageList->LoadPageListForModule($module);
		$result = $pageList->GetItems();

		$page = new Page();

		for ($i = 0; $i < count($result); $i++)
		{
			$page->LoadByID($result[$i]['PageID']);
			$data[strtoupper($module).'_'.$result[$i]['PageStaticPath'].'_URL'] = $page->GetPageURL(false);
		}

		return $data;
	}
}

?>