<?php

require_once(dirname(__FILE__)."/../init.php");
es_include("localobject.php");

class InfoblockItem extends LocalObject
{
	var $_acceptMimeTypes = array(
		'image/png',
		'image/x-png',
		'image/gif',
		'image/jpeg',
		'image/pjpeg'
	);
	var $module;
	var $pageID;
	var $params;
	var $config;

	function InfoblockItem($module, $pageID, $config = array(), $data = array())
	{
		parent::LocalObject($data);

		$this->module = $module;
		$this->pageID = intval($pageID);
		$this->config = is_array($config) ? $config : array();

		if (count($this->config) > 0)
		{
			$this->params = LoadImageConfig('ItemImage', $this->module, $this->config['ItemImage'].",".INFOBLOCK_ITEM_IMAGE);
		}
	}

	function LoadByID($itemID)
	{
		$query = "SELECT ItemID, PageID, CategoryID, ItemDate, Title, Description,
				ItemImage, ItemImageWidth, ItemImageHeight, MetaTitle, MetaKeywords,
				MetaDescription, StaticPath, Content, SortOrder, Active
			FROM `infoblock_item`
			WHERE ItemID=".Connection::GetSQLString($itemID);
		$this->LoadFromSQL($query);

		$this->_PrepareContentBeforeShow();

		if ($this->GetProperty("ItemID"))
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	function LoadByStaticPath($request)
	{
		if (is_null($request->GetProperty('BaseURL')))
			$request->SetProperty('BaseURL', '');

		$query = "SELECT ItemID, PageID, CategoryID, ItemDate, Title, Description,
				ItemImage, ItemImageWidth, ItemImageHeight, MetaTitle, MetaKeywords,
				MetaDescription, StaticPath, Content, SortOrder, Active,
				CONCAT(".$request->GetPropertyForSQL('BaseURL').", '/', StaticPath, ".Connection::GetSQLString(HTML_EXTENSION).") AS ItemURL
			FROM `infoblock_item`
			WHERE PageID=".$this->pageID." AND
				StaticPath=".$request->GetPropertyForSQL('StaticPath');

		if ($request->GetIntProperty('CategoryID') > 0)
			$query .= " AND CategoryID=".$request->GetIntProperty('CategoryID');

		$this->LoadFromSQL($query);

		$this->_PrepareContentBeforeShow();

		if ($this->GetProperty("ItemID"))
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	function _PrepareContentBeforeShow()
	{
		if ($this->GetProperty("ItemID"))
		{
			$this->SetProperty("Content", str_replace("<P_T_R>", PROJECT_PATH, $this->GetProperty("Content")));
		}

		if ($this->GetProperty("ItemImage"))
		{
			$origW = $this->GetProperty("ItemImageWidth");
			$origH = $this->GetProperty("ItemImageHeight");

			for ($i = 0; $i < count($this->params); $i++)
			{
				$v = $this->params[$i];

				$this->SetProperty($v["Name"]."Path", $v["Path"]."item/".$this->GetProperty("ItemImage"));

				if ($v["Name"] != 'ItemImage')
				{
					list($dstW, $dstH) = GetRealImageSize($v["Resize"], $origW, $origH, $v["Width"], $v["Height"]);
					$this->SetProperty($v["Name"]."Width", $dstW);
					$this->SetProperty($v["Name"]."Height", $dstH);
				}
			}
		}
	}

	function Save()
	{
		$result1 = $this->SaveItemImage($this->GetProperty("SavedItemImage"));
		$result2 = $this->Validate();
		if (!$result1 || !$result2)
		{
			$this->_PrepareContentBeforeShow();
			return false;
		}

		/*@var stmt Statement */
		$stmt = GetStatement();

		$content = PrepareContentBeforeSave($this->GetProperty("Content"));

		if ($this->GetIntProperty("ItemID") > 0)
		{
			$query = "SELECT CategoryID FROM `infoblock_item` WHERE ItemID=".$this->GetIntProperty("ItemID");
			$oldCategoryID = $stmt->FetchField($query);
			// Move to new category (to update SortOrder correctly)
			if ($oldCategoryID != $this->GetProperty('CategoryID'))
			{
				$itemList = new InfoblockItemList($this->module, $this->config);
				$itemList->MoveTo(array($this->GetProperty('ItemID')), $this->pageID, $this->GetProperty('CategoryID'));
			}

			$query = "UPDATE `infoblock_item` SET
					ItemDate=".$this->GetPropertyForSQL("ItemDate").",
					Title=".$this->GetPropertyForSQL("Title").",
					Description=".$this->GetPropertyForSQL("Description").",
					ItemImage=".$this->GetPropertyForSQL("ItemImage").",
					ItemImageWidth=".$this->GetPropertyForSQL("ItemImageWidth").",
					ItemImageHeight=".$this->GetPropertyForSQL("ItemImageHeight").",
					MetaTitle=".$this->GetPropertyForSQL("MetaTitle").",
					MetaKeywords=".$this->GetPropertyForSQL("MetaKeywords").",
					MetaDescription=".$this->GetPropertyForSQL("MetaDescription").",
					StaticPath=".$this->GetPropertyForSQL("StaticPath").",
					Content=".Connection::GetSQLString($content).",
					Active=".$this->GetPropertyForSQL("Active")."
				WHERE ItemID=".$this->GetIntProperty("ItemID");
		}
		else
		{
			$query = "SELECT MAX(SortOrder) FROM `infoblock_item`
				WHERE PageID=".$this->pageID." AND
					CategoryID".(is_null($this->GetProperty("CategoryID")) ? " IS NULL" : "=".$this->GetIntProperty("CategoryID"));
			if ($sortOrder = $stmt->FetchField($query))
				$sortOrder = $sortOrder + 1;
			else
				$sortOrder = 1;

			$query = "INSERT INTO `infoblock_item` (PageID, CategoryID, ItemDate,
				Title, Description, ItemImage, ItemImageWidth, ItemImageHeight,
				MetaTitle, MetaKeywords, MetaDescription,
				StaticPath, Content, SortOrder, Active)
				VALUES (
				".$this->pageID.",
				".$this->GetPropertyForSQL("CategoryID").",
				".$this->GetPropertyForSQL("ItemDate").",
				".$this->GetPropertyForSQL("Title").",
				".$this->GetPropertyForSQL("Description").",
				".$this->GetPropertyForSQL("ItemImage").",
				".$this->GetPropertyForSQL("ItemImageWidth").",
				".$this->GetPropertyForSQL("ItemImageHeight").",
				".$this->GetPropertyForSQL("MetaTitle").",
				".$this->GetPropertyForSQL("MetaKeywords").",
				".$this->GetPropertyForSQL("MetaDescription").",
				".$this->GetPropertyForSQL("StaticPath").",
				".Connection::GetSQLString($content).",
				".$sortOrder.",
				".$this->GetPropertyForSQL("Active").")";
		}

		if ($stmt->Execute($query))
		{
			if (!($this->GetIntProperty("ItemID") > 0))
			{
				$this->SetProperty("ItemID", $stmt->GetLastInsertID());
			}
			if ($this->GetIntProperty("CategoryID"))
			{
				$query = "UPDATE `infoblock_category` SET Modified=NOW()
					WHERE CategoryID=".$this->GetIntProperty("CategoryID");
				$stmt->Execute($query);
			}
			return true;
		}
		else
		{
			$this->AddError("sql-error");
			return false;
		}
	}

	function Validate()
	{
		if ($this->GetProperty("Active") != "N")
			$this->SetProperty("Active", "Y");

		if (!$this->GetProperty("ItemDate"))
			$this->AddError("item-date-empty", $this->module);

		if ($this->IsPropertySet("CategoryID") && $this->GetIntProperty("CategoryID") < 1)
			$this->SetProperty("CategoryID", null);

		if (!$this->GetProperty("Title"))
			$this->AddError("item-title-empty", $this->module);

		if (!$this->GetProperty("StaticPath"))
		{
			$this->AddError("item-static-path-empty", $this->module);
		}
		else if (!preg_match("/^[a-z0-9\._-]+$/i", $this->GetProperty("StaticPath")))
		{
			$this->AddError("static-path-incorrect");
		}
		else if (preg_match("/^[0-9]+$/", $this->GetProperty("StaticPath")))
		{
			$this->AddError("item-static-path-incorrect", $this->module);
		}
		else
		{
			/*@var stmt Statement */
			$stmt = GetStatement();

			$query = "SELECT COUNT(ItemID) FROM `infoblock_item` WHERE
				PageID=".$this->pageID." AND
				StaticPath=".$this->GetPropertyForSQL("StaticPath")." AND
				CategoryID".(is_null($this->GetProperty("CategoryID")) ? " IS NULL" : "=".$this->GetIntProperty("CategoryID"))."
				AND ItemID!=".$this->GetIntProperty("ItemID");
			if ($stmt->FetchField($query) > 0)
			{
				$this->AddError("static-path-is-not-unique");
			}
		}

		return !$this->HasErrors();
	}

	function SwitchActive($itemID, $active)
	{
		if ($active != 'Y') $active = 'N';
		$stmt = GetStatement();
		$stmt->Execute("UPDATE `infoblock_item` SET Active='".$active."'
			WHERE ItemID=".intval($itemID));
	}

	function SaveItemImage($savedImage = "")
	{
		$fileSys = new FileSys();

		$original = false;
		if ($this->config['ItemImageKeepFileName'])
		{
			if ($savedImage)
				$original = $savedImage;
			else
				$original = true;
		}

		$newItemImage = $fileSys->Upload("ItemImage", INFOBLOCK_IMAGE_DIR."item/", $original, $this->_acceptMimeTypes);
		if ($newItemImage)
		{
			$this->SetProperty("ItemImage", $newItemImage["FileName"]);

			// Remove old image if it has different name
			if ($savedImage && $savedImage != $newItemImage["FileName"])
				@unlink(INFOBLOCK_IMAGE_DIR."item/".$savedImage);
		}
		else
		{
			if ($savedImage)
				$this->SetProperty("ItemImage", $savedImage);
			else
				$this->SetProperty("ItemImage", null);
		}

		$this->SetProperty("ItemImageWidth", 0);
		$this->SetProperty("ItemImageHeight", 0);

		if ($this->GetProperty('ItemImage'))
		{
			if ($info = @getimagesize(INFOBLOCK_IMAGE_DIR."item/".$this->GetProperty('ItemImage')))
			{
				$this->SetProperty("ItemImageWidth", $info[0]);
				$this->SetProperty("ItemImageHeight", $info[1]);
			}
		}

		$this->LoadErrorsFromObject($fileSys);

		return !$fileSys->HasErrors();
	}

	function RemoveItemImage($itemID, $savedImage)
	{
		if ($savedImage)
		{
			@unlink(INFOBLOCK_IMAGE_DIR."item/".$savedImage);
		}

		$itemID = intval($itemID);
		if ($itemID > 0)
		{
			$stmt = GetStatement();
			$imageFile = $stmt->FetchField("SELECT ItemImage
				FROM `infoblock_item`
				WHERE ItemID=".$itemID." AND PageID=".$this->pageID);

			if ($imageFile)
				@unlink(INFOBLOCK_IMAGE_DIR."item/".$imageFile);

			$stmt->Execute("UPDATE `infoblock_item` SET
				ItemImage=NULL, ItemImageWidth=0, ItemImageHeight=0
				WHERE ItemID=".$itemID." AND PageID=".$this->pageID);
		}
	}
}

?>