<?php

define("IS_ADMIN", true);
require_once(dirname(__FILE__)."/../../include/init.php");
es_include("js_http_request/JsHttpRequest.php");
es_include("page.php");
es_include("user.php");

require_once(dirname(__FILE__)."/init.php");
require_once(dirname(__FILE__)."/include/category.php");
require_once(dirname(__FILE__)."/include/category_list.php");
require_once(dirname(__FILE__)."/include/item.php");
require_once(dirname(__FILE__)."/include/item_list.php");

$module = "infoblock";

$language =& GetLanguage();

$JsHttpRequest = new JsHttpRequest($language->GetHTMLCharset());

$user = new User();
if (!$user->LoadBySession() || !$user->Validate(array(INTEGRATOR, ADMINISTRATOR, MODERATOR)))
{
	$_RESULT["SessionExpired"] = GetTranslation("your-session-expired");
	exit();
}

$post = new LocalObject(array_merge($_GET, $_POST));
switch ($post->GetProperty("Action"))
{
	case "RemoveCategoryImage":
		$page = new Page();
		if ($page->LoadByID($post->GetProperty("PageID")))
		{
			$category = new InfoblockCategory($module, $page->GetProperty("PageID"), $page->GetConfig());
			$category->RemoveCategoryImage($post->GetProperty("ItemID"), $post->GetProperty('SavedImage'));
			$_RESULT["Answer"] = true;
		}
		else
		{
			$_RESULT["Answer"] = false;
		}
		break;

	case "RemoveItemImage":
		$page = new Page();
		if ($page->LoadByID($post->GetProperty("PageID")))
		{
			$item = new InfoblockItem($module, $page->GetProperty("PageID"), $page->GetConfig());
			$item->RemoveItemImage($post->GetProperty("ItemID"), $post->GetProperty('SavedImage'));
			$_RESULT["Answer"] = true;
		}
		else
		{
			$_RESULT["Answer"] = false;
		}
		break;

	case "SwitchItem":
		$item = new InfoblockItem($post->GetProperty('Module'));
		$item->SwitchActive($post->GetProperty('ItemID'), $post->GetProperty('Active'));
		$_RESULT["Answer"] = true;
		break;

	case "SetItemSortOrder":
		$itemList = new InfoblockItemList($post->GetProperty('Module'));
		$_RESULT["Answer"] = $itemList->SetSortOrder($post->GetProperty('ItemID'), $post->GetProperty('CategoryID'), $post->GetProperty('SortOrder'));
		break;

	case "SwitchCategory":
		$category = new InfoblockCategory($post->GetProperty('Module'));
		$category->SwitchActive($post->GetProperty('CategoryID'), $post->GetProperty('Active'));
		$_RESULT["Answer"] = true;
		break;

	case "SetCategorySortOrder":
		$categoryList = new InfoblockCategoryList($post->GetProperty('Module'));
		$_RESULT["Answer"] = $categoryList->SetSortOrder($post->GetProperty('CategoryID'), $post->GetProperty('PageID'), $post->GetProperty('SortOrder'));
		break;

	default:
		$_RESULT["Answer"] = false;
		break;
}

?>