<?php

if (!defined('IS_ADMIN'))
{
	echo "Incorrect call to admin interface";
	exit();
}

require_once(dirname(__FILE__)."/init.php");
require_once(dirname(__FILE__)."/include/category_list.php");
require_once(dirname(__FILE__)."/include/category.php");
require_once(dirname(__FILE__)."/include/item_list.php");
require_once(dirname(__FILE__)."/include/item.php");
es_include("js_calendar/calendar.php");
es_include("urlfilter.php");

$module = $request->GetProperty('load');
$adminPage = new AdminPage($module);
$urlFilter = new URLFilter();

if ($request->IsPropertySet("ItemID"))
{
	// Edit item details
	$page = DefineInitialPage($request);
	if (is_null($page))
	{
		header("Location: ".$moduleURL);
		exit();
	}
	else
	{
		$request->SetProperty("PageID", $page->GetProperty("PageID"));
	}
	$config = $page->GetConfig();

	$urlFilter->LoadFromObject($request, array('PageID', 'ViewCategoryID', 'Page'));

	if ($request->GetProperty("ItemID") > 0)
		$title = GetTranslation("title-item-edit", $module);
	else
		$title = GetTranslation("title-item-add", $module);

	$category = new InfoblockCategory($module, $page->GetIntProperty("PageID"), $config);
	if ($category->LoadByID($request->GetProperty('ViewCategoryID')))
	{
		$navigation = array(
			array("Title" => GetTranslation("module-admin-title", $module), "Link" => $moduleURL),
			array("Title" => $page->GetProperty("Title"), "Link" => $moduleURL."&".$urlFilter->GetForURL(array('ViewCategoryID'))),
			array("Title" => $category->GetProperty("Title"), "Link" => $moduleURL."&".$urlFilter->GetForURL()),
			array("Title" => $title, "Link" => $moduleURL."&".$urlFilter->GetForURL()."&ItemID=".$request->GetProperty("ItemID"))
		);
	}
	else
	{
		$navigation = array(
			array("Title" => GetTranslation("module-admin-title", $module), "Link" => $moduleURL),
			array("Title" => $page->GetProperty("Title"), "Link" => $moduleURL."&".$urlFilter->GetForURL()),
			array("Title" => $title, "Link" => $moduleURL."&".$urlFilter->GetForURL()."&ItemID=".$request->GetProperty("ItemID"))
		);
		$request->SetProperty('ViewCategoryID', '');
		$urlFilter->SetProperty('ViewCategoryID', '');
	}
	$styleSheets = array(
		array("StyleSheetFile" => PROJECT_PATH."include/js_calendar/skins/calendar-win2k-1.css")
	);
	$javaScripts = array(
		array("JavaScriptFile" => PROJECT_PATH."include/js_http_request/JsHttpRequest.js"),
		array("JavaScriptFile" => PROJECT_PATH."include/js_http_request/JsHttpRequest-prototype2.js"),
		array("JavaScriptFile" => ADMIN_PATH."js/file.js"),
		array("JavaScriptFile" => FCKEDITOR_PATH."fckeditor.js")
	);
	$header = array(
		"Title" => $title,
		"Navigation" => $navigation,
		"StyleSheets" => $styleSheets,
		"JavaScripts" => $javaScripts
	);
	$content = $adminPage->Load("item_edit.html", $header);

	$item = new InfoblockItem($module, $page->GetIntProperty("PageID"), $config);

	if ($request->GetProperty("Save"))
	{
		$item->LoadFromObject($request);
		if ($item->Save())
		{
			header("location: ".$moduleURL."&".$urlFilter->GetForURL());
			exit();
		}
		else
		{
			$content->LoadErrorsFromObject($item);
		}
	}
	else
	{
		if ($item->LoadByID($request->GetProperty("ItemID")))
			$request->SetProperty('CategoryID', $item->GetProperty('CategoryID'));
		else
			$request->SetProperty('CategoryID', $urlFilter->GetProperty('ViewCategoryID'));
	}

	$content->LoadFromObject($item);

	$content->SetVar('L_MetaTitle', GetTranslation('meta-title'));
	$content->SetVar('L_MetaKeywords', GetTranslation('meta-keywords'));
	$content->SetVar('L_MetaDescription', GetTranslation('meta-description'));

	$calendar = new Calendar("ItemDate", $item->GetProperty("ItemDate"));
	$content->SetVar("CalendarField", $calendar->GetHTMLAsField());

	$categoryList = new InfoblockCategoryList($module, $config);
	$categoryList->Load($request);
	$content->LoadFromObjectList("CategoryList", $categoryList);

	$content->SetVar("ParamsForURL", $urlFilter->GetForURL());
	$content->SetVar("ParamsForForm", $urlFilter->GetForForm());

	$content->SetVar("URLPrefix", $page->GetPagePrefix()."/");

	// Set correct parent url for selected category id
	if ($categoryList->GetCountTotalItems() > 0)
	{
		$items = $categoryList->GetItems();
		for ($i = 0; $i < count($items); $i++)
		{
			if ($items[$i]['Selected'])
			{
				$content->SetVar("ParentURL", $items[$i]['StaticPath'].'/');
				break;
			}
		}
	}
	$content->SetVar("PageID", $request->GetIntProperty('PageID'));
}
else if ($request->IsPropertySet("CategoryID"))
{
	// Edit category
	$page = DefineInitialPage($request);
	if (is_null($page))
	{
		header("Location: ".$moduleURL);
		exit();
	}
	else
	{
		$request->SetProperty("PageID", $page->GetProperty("PageID"));
	}
	$config = $page->GetConfig();

	if ($request->GetIntProperty("CategoryID") > 0)
		$title = GetTranslation("title-category-edit", $module);
	else
		$title = GetTranslation("title-category-add", $module);

	$javaScripts = array(
		array("JavaScriptFile" => PROJECT_PATH."include/js_http_request/JsHttpRequest.js"),
		array("JavaScriptFile" => PROJECT_PATH."include/js_http_request/JsHttpRequest-prototype2.js"),
		array("JavaScriptFile" => ADMIN_PATH."js/file.js"),
		array("JavaScriptFile" => FCKEDITOR_PATH."fckeditor.js"),
	);
	$navigation = array(
		array("Title" => GetTranslation("module-admin-title", $module), "Link" => $moduleURL),
		array("Title" => GetTranslation("title-category-add", $module), "Link" => $moduleURL."&PageID=".$request->GetProperty("PageID")."&CategoryID=".$request->GetProperty('CategoryID'))
	);
	$header = array(
		"Title" => $title,
		"Navigation" => $navigation,
		"JavaScripts" => $javaScripts
	);
	$content = $adminPage->Load("category_edit.html", $header);

	$category = new InfoblockCategory($module, $page->GetIntProperty("PageID"), $config);

	if ($request->GetProperty("Save"))
	{
		$category->LoadFromObject($request);
		if ($category->Save())
		{
			header("location: ".$moduleURL);
			exit();
		}
		else
		{
			$content->LoadErrorsFromObject($category);
		}
	}
	else
	{
		$category->LoadByID($request->GetProperty("CategoryID"));
	}

	$content->LoadFromObject($category);

	$content->SetVar('L_MetaTitle', GetTranslation('meta-title'));
	$content->SetVar('L_MetaKeywords', GetTranslation('meta-keywords'));
	$content->SetVar('L_MetaDescription', GetTranslation('meta-description'));

	$content->SetVar("PageID", $request->GetIntProperty('PageID'));
	$content->SetVar("URLPrefix", $page->GetPagePrefix()."/");
}
else if ($request->IsPropertySet("PageID"))
{
	// View item list
	$page = DefineInitialPage($request);
	if (is_null($page))
	{
		header("Location: ".$moduleURL);
		exit();
	}
	else
	{
		$request->SetProperty("PageID", $page->GetProperty("PageID"));
	}
	$config = $page->GetConfig();

	$urlFilter->LoadFromObject($request, array('PageID', 'ViewCategoryID'));

	$category = new InfoblockCategory($module, $page->GetIntProperty("PageID"), $config);
	if ($category->LoadByID($request->GetProperty('ViewCategoryID')))
	{
		$navigation = array(
			array("Title" => GetTranslation("module-admin-title", $module), "Link" => $moduleURL),
			array("Title" => $page->GetProperty("Title"), "Link" => $moduleURL."&".$urlFilter->GetForURL(array('ViewCategoryID'))),
			array("Title" => $category->GetProperty("Title"), "Link" => $moduleURL."&".$urlFilter->GetForURL())
		);
	}
	else
	{
		$navigation = array(
			array("Title" => GetTranslation("module-admin-title", $module), "Link" => $moduleURL),
			array("Title" => $page->GetProperty("Title"), "Link" => $moduleURL."&".$urlFilter->GetForURL())
		);
		$request->SetProperty('ViewCategoryID', '');
		$urlFilter->SetProperty('ViewCategoryID', '');
	}
	$javaScripts = array(
		array("JavaScriptFile" => PROJECT_PATH."include/js_http_request/JsHttpRequest.js"),
		array("JavaScriptFile" => PROJECT_PATH."include/js_http_request/JsHttpRequest-prototype2.js")
	);
	$header = array(
		"Title" => $page->GetProperty("Title"),
		"Navigation" => $navigation,
		"JavaScripts" => $javaScripts
	);
	$content = $adminPage->Load("item_list.html", $header);

	$itemList = new InfoblockItemList($module, $config);

	if ($request->GetProperty("ListIDs"))
	{
		if ($request->GetProperty('Do') == 'Remove')
			$itemList->RemoveByItemIDs($request->GetProperty("ListIDs"));
		else if ($request->GetProperty('Do') == 'MoveTo')
			$itemList->MoveTo($request->GetProperty("ListIDs"), $page->GetProperty('PageID'), $request->GetProperty("ToCategoryID"));
	}

	if ($config['ItemsOrderBy'] == 'Position')
		$content->SetVar('ShowSortOrder', true);

	$itemList->Load($request);
	$content->LoadFromObjectList("ItemList", $itemList);
	$content->LoadMessagesFromObject($itemList);

	$request->SetProperty('CategoryID', $request->GetProperty('ViewCategoryID'));
	$categoryList = new InfoblockCategoryList($module, $config);
	$categoryList->Load($request);
	$content->LoadFromObjectList("CategoryList", $categoryList);

	$content->SetVar("NoCategory", $page->GetProperty('Title'));

	$content->SetVar("Paging", $itemList->GetPagingAsHTML($moduleURL.'&'.$urlFilter->GetForURL()));
	$content->SetVar("ListInfo", GetTranslation('list-info1', array('Page' => $itemList->GetItemsRange(), 'Total' => $itemList->GetCountTotalItems())));

	$urlFilter->SetProperty('Page', $itemList->GetCurrentPage());
	$content->SetVar("ParamsForURL", $urlFilter->GetForURL());
	$content->SetVar("ParamsForForm", $urlFilter->GetForForm(array('ViewCategoryID')));
	$content->SetVar("PageID", $page->GetProperty('PageID'));
}
else
{
	$navigation = array(
		array("Title" => GetTranslation("module-admin-title", $module), "Link" => $moduleURL)
	);
	$javaScripts = array(
		array("JavaScriptFile" => PROJECT_PATH."include/js_http_request/JsHttpRequest.js"),
		array("JavaScriptFile" => PROJECT_PATH."include/js_http_request/JsHttpRequest-prototype2.js")
	);
	$header = array(
		"Title" => GetTranslation("module-admin-title", $module),
		"Navigation" => $navigation,
		"JavaScripts" => $javaScripts
	);
	$content = $adminPage->Load("category_list.html", $header);

	$categoryList = new InfoblockCategoryList($module);

	$ids = $request->GetProperty("PageIDs");
	if (is_array($ids) && count($ids) > 0)
	{
		$page = new Page();

		for ($i = 0; $i < count($ids); $i++)
		{
			$page->Remove($ids[$i]);
		}
		$content->LoadMessagesFromObject($page);
	}
	else if ($request->GetProperty("CategoryIDs"))
	{
		$categoryList->RemoveByCategoryIDs($request->GetProperty("CategoryIDs"));
		$content->LoadMessagesFromObject($categoryList);
	}

	$categoryList->LoadGroupByPage($request);
	$content->LoadFromObjectList("PageList", $categoryList);
}

$adminPage->Output($content);

?>