<?php

define("IS_ADMIN", true);
require_once(dirname(__FILE__)."/../../include/init.php");
es_include("js_http_request/JsHttpRequest.php");
es_include("page.php");
es_include("user.php");

require_once(dirname(__FILE__)."/init.php");
require_once(dirname(__FILE__)."/include/category.php");
require_once(dirname(__FILE__)."/include/category_list.php");
require_once(dirname(__FILE__)."/include/media.php");
require_once(dirname(__FILE__)."/include/media_list.php");

$module = "gallery";

$language =& GetLanguage();

$JsHttpRequest = new JsHttpRequest($language->GetHTMLCharset());

$user = new User();
if (!$user->LoadBySession() || !$user->Validate(array(INTEGRATOR, ADMINISTRATOR, MODERATOR)))
{
	$_RESULT["SessionExpired"] = GetTranslation("your-session-expired");
	exit();
}

$post = new LocalObject(array_merge($_GET, $_POST));
switch ($post->GetProperty("Action"))
{
	case "RemoveCategoryImage":
		$page = new Page();
		if ($page->LoadByID($post->GetProperty("PageID")))
		{
			$category = new GalleryCategory($module, $page->GetProperty("PageID"), $page->GetConfig());
			$category->RemoveCategoryImage($post->GetProperty("ItemID"), $post->GetProperty('SavedImage'));
			$_RESULT["Answer"] = true;
		}
		else
		{
			$_RESULT["Answer"] = false;
		}
		break;

	case "SwitchCategory":
		$category = new GalleryCategory($post->GetProperty('Module'));
		$category->SwitchActive($post->GetProperty('CategoryID'), $post->GetProperty('Active'));
		$_RESULT["Answer"] = true;
		break;

	case "SetCategorySortOrder":
		$categoryList = new GalleryCategoryList($post->GetProperty('Module'));
		$_RESULT["Answer"] = $categoryList->SetSortOrder($post->GetProperty('CategoryID'), $post->GetProperty('PageID'), $post->GetProperty('SortOrder'));
		break;

	case "LoadMedia":
		$media = new GalleryMedia($module, $post->GetIntProperty('PageID'));
		$media->LoadByID($post->GetProperty('MediaID'));
		$_RESULT["Answer"] = $media->GetProperties();
		break;

	case "SaveMedia":
		$media = new GalleryMedia($module, $post->GetIntProperty('PageID'));
		$media->LoadFromObject($post);

		if ($media->UpdateMediaInfo())
		{
			$_RESULT['Answer'] = $media->GetIntProperty('SortOrder');
		}
		else
		{
			$_RESULT['Error'] = $media->GetErrorsAsString();
		}
		break;

	case "RemoveMedia":
		$mediaList = new GalleryMediaList($module, $post->GetIntProperty('PageID'));
		$mediaList->RemoveByMediaIDs($post->GetProperty('MediaID'));
		$_RESULT["Answer"] = true;
		break;

	default:
		$_RESULT["Answer"] = false;
		break;
}

?>