<?php
define('IS_ADMIN', true);
require_once(dirname(__FILE__)."/../../../include/init.php");
$expire = mktime(0, 0, 0, date("m")+COOKIE_EXPIRE, date("d"), date("Y"));
$expireDate = date("Y", $expire).", ".date("n", $expire).", ".date("j", $expire);
?>
var CategoryEdit = Class.create();

CategoryEdit.prototype = {
	initialize: function(form, pageID)
	{
		this.path2Admin = '<?php echo PROJECT_PATH."module/catalog/"; ?>';
		this.ajaxBusy = false;
		this.form = form;
		this.pageID = pageID;

		var elmList = form.getElements().findAll((function(s)
		{
			if (s.tagName == 'SELECT' && s.name.substr(0, 6) == 'Select')
				return true;
			else
				return false;
		}));

		for (var i = 0; i < elmList.length; i++)
		{
			Event.observe(elmList[i], 'change', this.parseEvent.bindAsEventListener(this));
		}
	},

	getID: function(elm)
	{
		return parseInt(elm.name.substr(6));
	},

	parseEvent: function(event)
	{
		if (this.ajaxBusy) return;
		var target = Event.element(event);

		target.disabled = true;
		var sID = cID = this.getID(target);
		$('ParentID').value = 0;

		if (target.selectedIndex == 0)
			cID = sID - 1;

		// Find which select boxes to remove
		var toRemove = new Array();
		var dropDowns = target.up(0).childElements();
		this.newSelect = null;
		for (var i = 0; i < dropDowns.length; i++)
		{
			if (dropDowns[i].tagName == 'SELECT' && this.getID(dropDowns[i]) > cID)
			{
				if (this.getID(dropDowns[i]) == cID + 1)
				{
					this.newSelect = dropDowns[i];
					this.newSelect.selectedIndex = 0;
				}
				else
				{
					toRemove[toRemove.length] = dropDowns[i];
				}
			}
			else if (dropDowns[i].tagName == 'SELECT')
			{
				$('ParentID').value = dropDowns[i].value;
			}
		}

		for (i = toRemove.length - 1; i > -1; i--)
		{
			toRemove[i].up(0).removeChild(toRemove[i]);
		}

		if (target.selectedIndex == 0)
		{
			target.disabled = false;
			window.focus();
			target.focus();

			var pathChunks = $('ParentURL').innerHTML.split('/');
			var newParentURL = '';
			if (pathChunks.length > sID + 1)
			{
				for (i = 0; i < sID; i++)
				{
					newParentURL = newParentURL + pathChunks[i] + '/';
				}
			}
			$('ParentURL').update(newParentURL);

			return;
		}

		this.ajaxBusy = true;

		new Ajax.Request(this.path2Admin+'ajax.php', {
			parameters:
			{
				'Action': 'GetChildren',
				'PageID': this.pageID,
				'CategoryID': target.value
			},
			onCreate: function() { $('debug').update(''); },
			onSuccess: function(tr)
			{
				var result = tr.transport.responseJS;
				if (result)
				{
					if (result.SessionExpired)
					{
						document.location.href = 'index.php';
						return;
					}

					if (!this.newSelect && result.CategoryList && result.CategoryList.length > 0)
					{
						this.newSelect = document.createElement('SELECT');
						this.newSelect.name = 'Select'+(sID+1);
						this.newSelect.className = 'fw150';
						Event.observe(this.newSelect, 'change', this.parseEvent.bindAsEventListener(this));
						this.newSelect.options[this.newSelect.options.length] = new Option('...', '');
						target.up(0).appendChild(this.newSelect);
					}

					$('ParentURL').update(result.CategoryPath)

					if (result.CategoryList && result.CategoryList.length > 0)
					{
						// Clear list of categories
						for (var i = this.newSelect.options.length - 1; i > 0; i--)
						{
							this.newSelect.remove(i);
						}
						// Fill list of categories
						for (var i = 0; i < result.CategoryList.length; i++)
						{
							if (parseInt(result.CategoryList[i]['CategoryID']) == parseInt($('CategoryID').value))
								continue;
							this.newSelect.options[this.newSelect.options.length] = new Option(result.CategoryList[i]['Title'], result.CategoryList[i]['CategoryID']);
						}
						if (this.newSelect.options.length == 1)
						{
							this.newSelect.up(0).removeChild(this.newSelect);
						}
					}
					else if (this.newSelect)
					{
						this.newSelect.up(0).removeChild(this.newSelect);
					}

					target.disabled = false;
					window.focus();
					target.focus();
				}
				this.ajaxBusy = false;
			}.bind(this),
			onFailure: function(tr)
			{
				$('debug').update(tr.responseText);
				this.ajaxBusy = false;
			}.bind(this)
		});
	}
}
