<?php

require_once(dirname(__FILE__)."/../init.php");
es_include("localobjectlist.php");

class CatalogListItemList extends LocalObjectList
{
	var $module;
	var $config;

	function CatalogListItemList($module, $config = array(), $data = array())
	{
		parent::LocalObjectList($data);

		$this->module = $module;
		$this->config = is_array($config) ? $config : array();
	}

	function LoadFullList($listNum, $pageID, $selected, $baseURL = '')
	{
		$listNum = abs(intval($listNum));

		$listPrefix = $baseURL.'/'.$this->config["List".$listNum."URLPrefix"].'/';

		$this->LoadFromSQL("SELECT List".$listNum."ID AS ListID, PageID, Title,
				Description, ListImage, MetaTitle, MetaKeywords,
				MetaDescription, StaticPath, SortOrder, Active,
				IF (List".$listNum."ID=".intval($selected).", 1, 0) AS Selected,
				CONCAT(".Connection::GetSQLString($listPrefix).", StaticPath, ".Connection::GetSQLString('/'.INDEX_PAGE.HTML_EXTENSION).") AS ListURL
			FROM `catalog_list".$listNum."`
			WHERE PageID=".intval($pageID)."
			ORDER BY SortOrder ASC, Title ASC");
	}

	function LoadNotEmptyList($listNum, $pageID, $selected, $baseURL = '')
	{
		$listNum = abs(intval($listNum));

		$listPrefix = $baseURL.'/'.$this->config["List".$listNum."URLPrefix"].'/';

		$this->LoadFromSQL("SELECT l.List".$listNum."ID AS ListID, l.PageID,
				l.Title, l.Description, l.ListImage, l.MetaTitle, l.MetaKeywords,
				l.MetaDescription, l.StaticPath, l.SortOrder, l.Active,
				IF (l.List".$listNum."ID=".intval($selected).", 1, 0) AS Selected,
				CONCAT(".Connection::GetSQLString($listPrefix).", l.StaticPath, ".Connection::GetSQLString('/'.INDEX_PAGE.HTML_EXTENSION).") AS ListURL
			FROM `catalog_list".$listNum."` AS l
				JOIN `catalog_item` AS i ON i.List".$listNum."ID=l.List".$listNum."ID
			WHERE l.PageID=".intval($pageID)."
			GROUP BY l.List".$listNum."ID
			ORDER BY l.SortOrder ASC, l.Title ASC");
	}
}

?>