<?php

require_once(dirname(__FILE__)."/../init.php");
es_include("localobject.php");

class CatalogListItem extends LocalObject
{
	var $module;
	var $pageID;

	function CatalogListItem($module, $pageID, $data = array())
	{
		parent::LocalObject($data);

		$this->module = $module;
		$this->pageID = intval($pageID);
	}

	function LoadByPath($request)
	{
		$listNum = abs($request->GetIntProperty("ListNumber"));

		$where = array();
		$where[] = "PageID=".$this->pageID;
		$where[] = "StaticPath=".$request->GetPropertyForSQL('ListStaticPath');
		if ($request->GetProperty('ShowActive') == 'N' || $request->GetProperty('ShowActive') == 'Y')
			$where[] = "Active=".$request->GetPropertyForSQL('ShowActive');

		$query = "SELECT List".$listNum."ID AS ListID, PageID, Title,
				Description, ListImage, MetaTitle, MetaKeywords,
				MetaDescription, StaticPath, SortOrder, Active, StaticPath
			FROM `catalog_list".$listNum."`
			".(count($where) > 0 ? "WHERE ".implode(" AND ", $where) : "")."
			ORDER BY SortOrder ASC, Title ASC LIMIT 1";
		$this->LoadFromSQL($query);

		if ($this->GetProperty("ListID"))
		{
			$this->SetProperty("ListURL", $request->GetProperty("ListBaseURL")."/".INDEX_PAGE.HTML_EXTENSION);
			return true;
		}
		else
		{
			return false;
		}
	}
}

?>