<?php

define("IS_ADMIN", true);
require_once(dirname(__FILE__)."/../../include/init.php");
es_include("js_http_request/JsHttpRequest.php");
es_include("localpage.php");
es_include("user.php");

require_once(dirname(__FILE__)."/init.php");
require_once(dirname(__FILE__)."/include/category.php");
require_once(dirname(__FILE__)."/include/category_list.php");
require_once(dirname(__FILE__)."/include/media.php");
require_once(dirname(__FILE__)."/include/media_list.php");
require_once(dirname(__FILE__)."/include/item.php");

$module = "catalog";

$language =& GetLanguage();

$JsHttpRequest = new JsHttpRequest($language->GetHTMLCharset());
$post = new LocalObject(array_merge($_GET, $_POST));

$user = new User();
if (!$user->LoadBySession() || !$user->Validate(array(INTEGRATOR, ADMINISTRATOR, MODERATOR)))
{
	$_RESULT["SessionExpired"] = GetTranslation("your-session-expired");
	exit();
}

switch ($post->GetProperty("Action"))
{
	case "LoadMeta":
		$category = new CatalogCategory($module, $post->GetProperty("PageID"));
		$_RESULT = $category->LoadMeta($post->GetProperty("CategoryID"));
		break;

	case "UpdateMeta":
		$category = new CatalogCategory($module, $post->GetProperty("PageID"));
		$category->UpdateMeta($post->GetProperty("CategoryID"), $post->GetProperty("MetaTitle"), $post->GetProperty("MetaKeywords"), $post->GetProperty("MetaDescription"));
		$_RESULT["Answer"] = true;
		break;

	case "RemoveCategory":
	    $page = new Page();
		if ($page->LoadByID($post->GetProperty("PageID")))
		{
			$category = new CatalogCategory($module, $post->GetProperty("PageID"), $page->GetConfig());
			$category->Remove($post->GetIntProperty("CategoryID"));
			$_RESULT["Answer"] = true;
		}
		else
		{
			$_RESULT["Answer"] = false;
		}
		break;

	case "SwitchCategories":
		$categoryList = new CatalogCategoryList($module);
		if ($categoryList->SwitchPages($post->GetProperty("UpCategoryID"), $post->GetProperty("DownCategoryID")))
			$_RESULT["Answer"] = true;
		break;

	case "RemoveCategoryImage":
		$page = new Page();
		if ($page->LoadByID($post->GetProperty("PageID")))
		{
			$category = new CatalogCategory($module, $page->GetProperty("PageID"), $page->GetConfig());
			$category->RemoveCategoryImage($post->GetProperty("ItemID"), $post->GetProperty('SavedImage'));
			$_RESULT["Answer"] = true;
		}
		else
		{
			$_RESULT["Answer"] = false;
		}
		break;

	case "RemoveItemImage":
		$page = new Page();
		if ($page->LoadByID($post->GetProperty("PageID")))
		{
			$item = new CatalogItem($module, $page->GetProperty("PageID"), $page->GetConfig());
			$item->RemoveItemImage($post->GetProperty("ItemID"), $post->GetProperty('SavedImage'), $post->GetProperty("ImageName"));
			$_RESULT["Answer"] = true;
		}
		else
		{
			$_RESULT["Answer"] = false;
		}
		break;

	case "GetChildren":
		$category = new CatalogCategory($module, $post->GetProperty("PageID"),false);
		$category->LoadByID($post->GetIntProperty("CategoryID"));
		$_RESULT["CategoryList"] = $category->GetChildren();
		$path = $category->GetPathAsArray();
		$categoryPath = '';
		for ($i = 0; $i < count($path); $i++)
		{
			$categoryPath .= $path[$i]['StaticPath'].'/';
		}
		$_RESULT["CategoryPath"] = $categoryPath;
		break;

	case "LoadMedia":
		$media = new CatalogMedia($module, $post->GetProperty('PageID'));
		$media->LoadByID($post->GetProperty('MediaID'));
		$_RESULT["Answer"] = $media->GetProperties();
		break;

	case "RemoveMedia":
		$mediaList = new CatalogMediaList($module, $post->GetProperty('PageID'));
		$mediaList->RemoveByMediaIDs($post->GetProperty('MediaID'));
		$_RESULT["Answer"] = true;
		break;

	case "SaveMedia":
		$media = new CatalogMedia($module, $post->GetProperty('PageID'));
		$media->LoadFromObject($post);

		if ($media->UpdateMediaInfo())
		{
			$_RESULT['Answer'] = $media->GetIntProperty('SortOrder');
		}
		else
		{
			$_RESULT['Error'] = $media->GetErrorsAsString();
		}
		break;

	case "SetItemSortOrder":
		$itemList = new CatalogItemList($module);
		$_RESULT["Answer"] = $itemList->SetSortOrder($post->GetProperty('ItemID'), $post->GetProperty('CategoryID'), $post->GetProperty('SortOrder'));
		break;

	case "SwitchActive":
		$item = new CatalogItem($module);
		$item->SwitchActive($post->GetProperty('ItemID'), $post->GetProperty('Active'));
		$_RESULT["Answer"] = true;
		break;

	default:
		$_RESULT["Answer"] = "";
		break;
}

?>