<?php

// PROJECT_PATH, DATA_LANGCODE & INTERFACE_LANGCODE are not used in this script
// init.php is used to load website.xml & define language class
require_once(dirname(__FILE__)."/../init.php");
es_include("page.php");
es_include("module.php");
es_include("js_http_request/JsHttpRequest.php");

$JsHttpRequest =& new JsHttpRequest("iso-8859-1");

$request = new LocalObject(array_merge($_GET, $_POST));

/*@var language Language */
$language =& GetLanguage();

$path = null;
$langCode = null;

$pageID = $request->GetProperty("PageID");
$langCode = $request->GetProperty("LangCode");

$page = new Page();
if ($page->LoadBySyncPageID($pageID, $langCode))
{
	if ($page->GetProperty('StaticPath') == INDEX_PAGE)
	{
		// It is index page
		$path = INDEX_PAGE.HTML_EXTENSION;
	}
	else
	{
		// We do not use PageURL from Array to avoid wrong URL because of incorrect call to GetDirPrefix()
		$pathChunks = $page->GetPathAsArray();
		array_shift($pathChunks);
		$path = "";
		foreach ($pathChunks as $k => $v)
		{
			$path .= $v["StaticPath"]."/";
		}
		if ($page->GetCountChildren() > 0)
		{
			$path .= INDEX_PAGE.HTML_EXTENSION;
		}
		else
		{
			$path = substr($path, 0, strlen($path) - 1).HTML_EXTENSION;
		}
	}
}

if (is_null($path))
{
	$_RESULT["Answer"] = GetUrlPrefix($langCode).INDEX_PAGE.HTML_EXTENSION;
}
else
{
	$_RESULT["Answer"] = GetUrlPrefix($langCode).$path;
}


?>