<?php

class Calendar
{

	var $_instanceName;
	var $_value;
	var $_valueFmt;
	var $_dateOnly;

	function Calendar($fieldName, $value = null, $dateOnly = false)
	{
		$this->_dateOnly = $dateOnly;

		if (strtotime($value))
		{
			$language =& GetLanguage();
			$this->_value = $value;
			if ($this->_dateOnly)
				$this->_valueFmt = LocalDate($language->GetDateFormat(), strtotime($value));
			else
				$this->_valueFmt = LocalDate($language->GetDateFormat()." ".$language->GetTimeFormat(), strtotime($value));
		}
		$this->_instanceName = $fieldName;
	}

	function GetHTMLAsField()
	{
		$language =& GetLanguage();

		if ($this->_dateOnly)
		{
			$valueIF = is_null($this->_value) ? date("Y-m-d") : $this->_value;
			$valueDA = is_null($this->_valueFmt) ? LocalDate($language->GetDateFormat()) : $this->_valueFmt;
			$format = $language->GetDateFormatForJS();
		}
		else
		{
			$valueIF = is_null($this->_value) ? date("Y-m-d H:i") : $this->_value;
			$valueDA = is_null($this->_valueFmt) ? LocalDate($language->GetDateFormat()." ".$language->GetTimeFormat()) : $this->_valueFmt;
			$format = $language->GetDateFormatForJS()." ".$language->GetTimeFormatForJS();
		}

		// TODO: Configure skin (CSS + images) of the js calendar
		$url2Image = PROJECT_PATH."include/js_calendar/skins/img.gif";
		$title = GetTranslation("open-calendar");

		$result = '<span id="'.$this->_instanceName.'Display" class="calendar-da">'.$valueDA.'</span>
<img src="'.$url2Image.'" id="'.$this->_instanceName.'Trigger" class="calendar-ctrl" alt="'.$title.'" />
<input type="hidden" name="'.$this->_instanceName.'" id="'.$this->_instanceName.'" value="'.$valueIF.'" />
<script type="text/javascript" src="'.PROJECT_PATH.'include/js_calendar/calendar.js"></script>
<script type="text/javascript" src="'.PROJECT_PATH.'include/js_calendar/calendar-setup.js"></script>
<script type="text/javascript" src="'.PROJECT_PATH.'language/'.INTERFACE_LANGCODE.'/js_calendar.js"></script>
<script type="text/javascript">
Calendar.setup({
	displayArea: "'.$this->_instanceName.'Display",
	inputField: "'.$this->_instanceName.'",
	ifFormat: "%Y-%m-%d %H:%M",
	daFormat: "'.$format.'",
	button: "'.$this->_instanceName.'Trigger",
	singleClick: true,
	align: "Br",
	showsTime: '.($this->_dateOnly ? "false" : "true").'});
</script>';
		return $result;
	}

}

?>