/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * Plugin to insert "Placeholders" in the editor.
 */

// Register the related command.
FCKCommands.RegisterCommand( 'Youtube', new FCKDialogCommand( 'Youtube', FCKLang.YoutubeDlgTitle, FCKPlugins.Items['youtube'].Path + 'fck_youtube.html', 400, 300 ) ) ;

// Create the "Plaholder" toolbar button.
var oYoutubeItem = new FCKToolbarButton( 'Youtube', FCKLang.YoutubeBtn ) ;
oYoutubeItem.IconPath = FCKPlugins.Items['youtube'].Path + 'youtube.png' ;

FCKToolbarItems.RegisterItem( 'Youtube', oYoutubeItem ) ;


// The object used for all Placeholder operations.
var FCKYoutubes = new Object() ;

// Add a new placeholder at the actual selection.
FCKYoutubes.Add = function( name )
{
	var oSpan = FCK.InsertElement( 'span' ) ;
	this.SetupSpan( oSpan, name ) ;
}

FCKYoutubes.SetupSpan = function( span, name )
{
	span.innerHTML = name;
        
	if ( FCKBrowserInfo.IsGecko )
		span.style.cursor = 'default' ;

	//span._fckyoutube = name ;
	//span.contentEditable = false ;

	// To avoid it to be resized.
	span.onresizestart = function()
	{
		FCK.EditorWindow.event.returnValue = false ;
		return false ;
	}
}

// On Gecko we must do this trick so the user select all the SPAN when clicking on it.
FCKYoutubes._SetupClickListener = function()
{
	FCKYoutubes._ClickListener = function( e )
	{
		if ( e.target.tagName == 'SPAN' && e.target._fckyoutube )
			FCKSelection.SelectNode( e.target ) ;
	}

	FCK.EditorDocument.addEventListener( 'click', FCKYoutubes._ClickListener, true ) ;
}

// Open the Placeholder dialog on double click.
FCKYoutubes.OnDoubleClick = function( span )
{
	if ( span.tagName == 'SPAN' && span._fckyoutube )
		FCKCommands.GetCommand( 'Youtube' ).Execute() ;
}

FCK.RegisterDoubleClickHandler( FCKYoutubes.OnDoubleClick, 'SPAN' ) ;

// Check if a Placholder name is already in use.
FCKYoutubes.Exist = function( name )
{
	var aSpans = FCK.EditorDocument.getElementsByTagName( 'SPAN' ) ;

	for ( var i = 0 ; i < aSpans.length ; i++ )
	{
		if ( aSpans[i]._fckyoutube == name )
			return true ;
	}

	return false ;
}


//FCK.Events.AttachEvent( 'OnAfterSetHTML', FCKYoutubes.Redraw ) ;

// We must process the SPAN tags to replace then with the real resulting value of the placeholder.
FCKXHtml.TagProcessors['span'] = function( node, htmlNode )
{
	if ( htmlNode._fckyoutube )
		node = FCKXHtml.XML.createTextNode( '[[' + htmlNode._fckyoutuber + ']]' ) ;
	else
		FCKXHtml._AppendChildNodes( node, htmlNode, false ) ;

	return node ;
}
