<?php
/*
 * CKFinder
 * ========
 * http://www.ckfinder.com
 * Copyright (C) 2007-2008 Frederico Caldeira Knabben (FredCK.com)
 *
 * The software, this file and its contents are subject to the CKFinder
 * License. Please read the license.txt file before using, installing, copying,
 * modifying or distribute this file or part of its contents. The contents of
 * this file is part of the Source Code of CKFinder.
 */

/**
 * @package CKFinder
 * @subpackage Config
 * @copyright Frederico Caldeira Knabben
 */

/**
 * This class keeps thumbnails configuration
 * 
 * @package CKFinder
 * @subpackage Config
 * @copyright Frederico Caldeira Knabben
 */
class CKFinder_Connector_Core_ThumbnailsConfig
{

    /**
     * Url to thumbnails directory
     *
     * @var string
     * @access private
     */
    private $_url = "";
    /**
	 * Directory where thumbnails are stored
	 *
	 * @var string
	 * @access private
	 */
    private $_directory = "";
    /**
	 * Are thumbnails enabled
	 *
	 * @var boolean
	 * @access private
	 */
    private $_isEnabled = false;
    /**
     * Max width for thumbnails
     *
     * @var int
     * @access private
     */
    private $_maxWidth = 100;
    /**
     * Max height for thumbnails
     *
     * @var int
     * @access private
     */
    private $_maxHeight = 100;
    /**
     * Quality of thumbnails
     *
     * @var int
     * @access private
     */
    private $_quality = 100;

    function __construct($thumbnailsNode)
    {
        if(extension_loaded('gd') && isset($thumbnailsNode['enabled'])) {
            $this->_isEnabled = CKFinder_Connector_Utils_Misc::booleanValue($thumbnailsNode['enabled']);
        }
        if(isset($thumbnailsNode['maxWidth'])) {
            $_maxWidth = intval($thumbnailsNode['maxWidth']);
            if($_maxWidth>=0) {
                $this->_maxWidth = $_maxWidth;
            }
        }
        if(isset($thumbnailsNode['maxHeight'])) {
            $_maxHeight = intval($thumbnailsNode['maxHeight']);
            if($_maxHeight>=0) {
                $this->_maxHeight = $_maxHeight;
            }
        }
        if(isset($thumbnailsNode['quality'])) {
            $_quality = intval($thumbnailsNode['quality']);
            if($_quality>0 && $_quality<=100) {
                $this->_quality = $_quality;
            }
        }

        if(isset($thumbnailsNode['url'])) {
            $this->_url = $thumbnailsNode['url'];
        }

        if(isset($thumbnailsNode['directory'])) {
            $this->_directory = $thumbnailsNode['directory'];
        }
    }

    /**
     * Get URL
     *
     * @access public
     * @return string
     */
    public function getUrl()
    {
        return $this->_url;
    }

    /**
     * Get directory
     *
     * @access public
     * @return string
     */
    public function getDirectory()
    {
        return $this->_directory;
    }

    /**
     * Get is enabled setting
     *
     * @access public
     * @return boolean
     */
    public function getIsEnabled()
    {
        return $this->_isEnabled;
    }

    /**
     * Get maximum width of a thumbnail
     *
     * @access public
     * @return int
     */
    public function getMaxWidth()
    {
        return $this->_maxWidth;
    }

    /**
     * Get maximum height of a thumbnail
     *
     * @access public
     * @return int
     */
    public function getMaxHeight()
    {
        return $this->_maxHeight;
    }

    /**
     * Get quality of a thumbnail (1-100)
     *
     * @access public
     * @return int
     */
    public function getQuality()
    {
        return $this->_quality;
    }
}
