<?php

define("IS_ADMIN", true);
require_once(dirname(__FILE__)."/../include/init.php");
es_include("localpage.php");
es_include("page.php");
es_include("pagelist.php");
es_include("user.php");
es_include("filesys.php");

$user = new User();
$user->ValidateAccess(array(INTEGRATOR, ADMINISTRATOR, MODERATOR));

$adminPage = new AdminPage();
$title = GetTranslation("title-site-structure");
$styleSheets = array(
	array("StyleSheetFile" => ADMIN_PATH."template/css/tree.css")
);
$fileSys = new FileSys();
$javaScripts = array(
	array("JavaScriptFile" => PROJECT_PATH."include/js_http_request/JsHttpRequest.js"),
	array("JavaScriptFile" => PROJECT_PATH."include/js_http_request/JsHttpRequest-prototype2.js"),
	array("JavaScriptFile" => PROJECT_PATH."include/scriptaculous/scriptaculous.js"),
	array("JavaScriptFile" => ADMIN_PATH."js/tree.js.php")
);
$navigation = array(
	array("Title" => $title, "Link" => "page_tree.php")
);
$header = array(
	"Title" => $title,
	"Navigation" => $navigation,
	"StyleSheets" => $styleSheets,
	"JavaScripts" => $javaScripts
);
$content = $adminPage->Load("page_tree.html", $header);
$content->SetLoop("Navigation", $navigation);
$content->SetVar('LanguageCode', DATA_LANGCODE);
$content->SetVar('Integrator', ($user->GetProperty('Role') == 'integrator' ? true : false));

// Load page list
$pageList = new PageList();
$content->SetLoop("PageList", $pageList->GetPageList());

// Load module list for ModuleForm
es_include("module.php");
$module = new Module();
$content->SetLoop("ModuleList", $module->GetModuleList());

$expire = mktime(0, 0, 0, date("m")+COOKIE_EXPIRE, date("d"), date("Y"));
$content->SetVar("CookieExpire", date("Y", $expire).", ".date("n", $expire).", ".date("j", $expire));

$adminPage->Output($content);

?>