<?php

define('IS_ADMIN', true);
require_once(dirname(__FILE__)."/../../include/init.php");
es_include("user.php");

$user = new User();
if (!($user->LoadBySession() && $user->Validate(array(INTEGRATOR, ADMINISTRATOR, MODERATOR))))
	exit;
?>
var VariableList = Class.create();

VariableList.prototype = {
	initialize: function(section)
	{
		var parts = section.split('/');

		if (parts.length >= 2)
		{
			this.module = parts[0];
			this.type = parts[1];
		}
		else
		{
			alert(GetTranslation('incorrect-parameter'));
		}

		if (parts.length > 2)
			this.template = parts[2];
		else
			this.template = '';

		this.path2Admin = '<?php echo ADMIN_PATH; ?>';
		this.path2Main = this.path2Admin+'template/';
		this.savingData = false;

		// Event observers
        Event.observe(document, 'click', this.parseClick.bindAsEventListener(this));
		Event.observe(document, 'keyup', (function(event){if (event.keyCode == 27){this.closePopups();}}).bindAsEventListener(this));

		var objBody = $$('body')[0];

		objBody.appendChild(Builder.node('div', {id: 'edit-variable', className: 'seo'}, [
			Builder.node('div', {id: 'edit-variable-loading'}, [
				Builder.node('img', {src: this.path2Main+'images/icons/loading16.gif', width: '16px', height: '16px'}),
				Builder.node('span').update(GetTranslation('loading-edit-variable'))
			]),
			Builder.node('form', {id: 'edit-variable-form'})
		]));
		$('edit-variable').hide();
		this.popup = $('edit-variable');

		// Image preloading
		this.preloadImages();
	},

	preloadImages: function()
	{
		var imageList = new Array();
		// Hovers
		imageList[imageList.length] = this.path2Main+'images/icons/seo-close-hover.png';
		// Now preload it
		var imgObj = new Image();
		for (var i = 0; i < imageList.length; i++)
			imgObj.src = imageList[i];
	},

	parseClick: function(event)
	{
		var target = Event.element(event);
		if (target.id.substr(0, 4) == 'tag-')
		{
			event.stop();
			if (!this.savingData)
			{
				if (this.popup.visible() && this.popup.childElements()[1].elements['TagName'] && this.popup.childElements()[1].elements['TagName'].value == target.id.substr(4))
					this.closeVariable();
				else
					this.editVariable(target.id.substr(4), $('val-'+target.id.substr(4)).innerHTML, event)
			}
		}
		switch (target.id)
		{
			case 'SaveVariable':
				event.stop();
				this.saveVariable();
				break;
			case 'CancelVariable':
			case 'CloseVariable':
				event.stop();
				if (!this.savingData) this.closeVariable();
				break;
		}
	},

	editVariable: function(tagName, value, event)
	{
		if (this.savingData)
			return;

		this.closePopups();

		// Show loading message
		var pos = $('tag-'+tagName).viewportOffset();
		if (Prototype.Browser.Opera)
			this.popup.setStyle({top: (pos.top + 15)+'px'});
		else
			this.popup.setStyle({top: (pos.top + this.getScrollTop() + 15)+'px'});
		this.popup.show();
		this.popup.setStyle({left: (Event.pointerX(event) - 30)+'px'});

		var nodeContent = '<div>';
		nodeContent += '	<label for="TagName">'+GetTranslation('tag-name')+'</label><br /><b>'+tagName+'</b>';
		nodeContent += '</div>';
		nodeContent += '<div>';
		nodeContent += '	<label for="VariableValue">'+GetTranslation('variable-value')+'</label><br /><textarea name="VariableValue" id="VariableValue" style="height: 150px;">'+value+'</textarea>';
		nodeContent += '</div>';
		nodeContent += '<div id="edit-variable-buttons">';
		nodeContent += '	<input class="btn" type="button" id="SaveVariable" value="'+GetTranslation('save')+'" /><input class="btn" type="button" id="CancelVariable" value="'+GetTranslation('cancel')+'" />';
		nodeContent += '</div>';
		nodeContent += '<div id="edit-variable-saving" style="display: none;">';
		nodeContent += '	<img src="'+this.path2Main+'images/icons/loading16.gif" width="16" height="16" alt="'+GetTranslation('saving-variable')+'" /><span>'+GetTranslation('saving-variable')+'</span>';
		nodeContent += '</div>';
		nodeContent += '<a href="#" class="close" id="CloseVariable">&nbsp;</a>';
		nodeContent += '<input type="hidden" name="Module" id="Module" value="'+this.module+'" />';
		nodeContent += '<input type="hidden" name="Type" id="Type" value="'+this.type+'" />';
		nodeContent += '<input type="hidden" name="Template" id="Template" value="'+this.template+'" />';
		nodeContent += '<input type="hidden" name="TagName" id="TagName" value="'+tagName+'" />';
		nodeContent += '<input type="hidden" name="Action" id="Action" value="SaveVariableToXML" />';

		this.popup.childElements()[1].update(nodeContent);
		this.popup.childElements()[0].hide();
		new Effect.Appear(this.popup.childElements()[1], {duration: 0.25});
	},

	saveVariable: function()
	{
		if (this.savingData) return;

		this.savingData = true;

		$('edit-variable-buttons').hide();
		$('edit-variable-saving').show();

		new Ajax.Request(this.path2Admin+'ajax.php', {
			parameters: this.popup.childElements()[1].serialize(true),
			onCreate: function() { $('debug').update(''); },
			onSuccess: function(tr)
			{
				var result = tr.transport.responseJS;
				var node = $('val-'+this.popup.childElements()[1].elements['TagName'].value);
				node.update(result.Answer);
				new Effect.Highlight(node.up(0), {startcolor: '#fff9d9', endcolor: '#ffffff', keepBackgroundImage: true, restorecolor: true});
			}.bind(this),
			onComplete: function(tr)
			{
				this.savingData = false;
				this.closeVariable();
				$('debug').update(tr.responseText);
			}.bind(this)
		});
	},

	closeVariable: function()
	{
		// Hide popup
		this.popup.hide();
		// Empty & hide form
		this.popup.childElements()[1].update('');
		this.popup.childElements()[1].hide();
		// Show loading message
		this.popup.childElements()[0].show();
	},

	closePopups: function()
	{
		if (this.popup.visible() && !this.savingData)
			this.closeVariable();
	},

	getScrollTop: function()
	{
		var scrollTop = 0;
		if (window.pageYOffset)
			scrollTop = window.pageYOffset;
		else if (document.documentElement.scrollTop)
			scrollTop = document.documentElement.scrollTop;
		else if (document.body.scrollTop)
			scrollTop = document.body.scrollTop;
		return scrollTop;
	}
}
