var oParser = new Object();

var oRegex = new Object();
oRegex.UriProtocol = /^(((http|https|ftp|news):\/\/)|mailto:)/gi;
oRegex.UrlOnChangeProtocol = /^(http|https|ftp|news):\/\/(?=.)/gi;
oRegex.UrlOnChangeTestOther = /^((javascript:)|[#\/\.])/gi;
oRegex.ReserveTarget = /^_(blank|self|top|parent)$/i;
oRegex.PopupUri = /^javascript:void\(\s*window.open\(\s*'([^']+)'\s*,\s*(?:'([^']*)'|null)\s*,\s*'([^']*)'\s*\)\s*\)\s*;\s*$/;
oRegex.PopupFeatures = /(?:^|,)([^=]+)=(\d+|yes|no)/gi;

//var y = new RegExp("/^(((http|https|ftp|news):\/\/)|mailto:)/gi");

oParser.ParseEMailUrl = function( emailUrl )
{
	// Initializes the EMailInfo object.
	var oEMailInfo = new Object();
	oEMailInfo.Address	= "";
	oEMailInfo.Subject	= "";
	oEMailInfo.Body		= "";

	var oParts = emailUrl.match( /^([^\?]+)\??(.+)?/ );
	if ( oParts )
	{
		// Set the e-mail address.
		oEMailInfo.Address = oParts[1];

		// Look for the optional e-mail parameters.
		if ( oParts[2] )
		{
			var oMatch = oParts[2].match( /(^|&)subject=([^&]+)/i );
			if ( oMatch ) oEMailInfo.Subject = unescape( oMatch[2] );

			oMatch = oParts[2].match( /(^|&)body=([^&]+)/i );
			if ( oMatch ) oEMailInfo.Body = unescape( oMatch[2] );
		}
	}

	return oEMailInfo;
}

oParser.CreateEMailUri = function( address, subject, body )
{
	var sBaseUri = "mailto:" + address;

	var sParams = "";

	if ( subject.length > 0 )
		sParams = "?subject=" + escape( subject );

	if ( body.length > 0 )
	{
		sParams += ( sParams.length == 0 ? "?" : "&" );
		sParams += "body=" + escape( body );
	}

	return sBaseUri + sParams;
}

function FillLinkDivFromHRef(sHRef, sTarget, pageList)
{
	var sType = "url";

	// Look for a popup javascript link.
	var oPopupMatch = oRegex.PopupUri.exec(sHRef);
	if (oPopupMatch)
	{
		$('cmbTarget').value = 'popup';
		sHRef = oPopupMatch[1];
		FillPopupFields(oPopupMatch[2], oPopupMatch[3]);
		SetTarget('popup');
	}

	// Here we have to try to find internal page
	internalPageFound = false;
	for (var i in pageList)
	{
		if (pageList[i]["PageURL"] != null && pageList[i]["PageURL"] != "" && pageList[i]["PageURL"] == sHRef)
		{
			$("cmbLinkInternalPage").value = sHRef;
			internalPageFound = true;
		}
	}

	// Search for the protocol
	oRegex.UriProtocol.lastIndex = 0;
	var sProtocol = oRegex.UriProtocol.exec(sHRef);

	if (sProtocol)
	{
		sProtocol = sProtocol[0].toLowerCase();

		// Remove the protocol and get the remainig URL
		var sUrl = sHRef.replace(sProtocol, "");

		if (sProtocol == "mailto:")
		{
			// It is an e-mail link
			sType = "email";
			var oEMailInfo = oParser.ParseEMailUrl(sUrl);
			$("txtEmailAddress").value = oEMailInfo.Address;
			$("txtEmailSubject").value = oEMailInfo.Subject;
			$("txtEmailBody").value = oEMailInfo.Body;
		}
		else
		{
			// It is a normal link
			sType = "url";
			$("cmbLinkProtocol").value = sProtocol;
			$("txtUrl").value = sUrl;
		}
	}
	else
	{
		if (internalPageFound)
		{
			// It is link to internal page
			sType = "internal";
		}
		else
		{
			// It is another type of link
			sType = "url";
			$("cmbLinkProtocol").value = "";
			$("txtUrl").value = sHRef;
		}
	}

	if (!oPopupMatch)
	{
		if (sTarget && sTarget.length > 0)
		{
			if (oRegex.ReserveTarget.test(sTarget))
			{
				sTarget = sTarget.toLowerCase();
				$('cmbTarget').value = sTarget;
			}
			else
			{
				$('cmbTarget').value = 'frame';
			}
			$('txtTargetFrame').value = sTarget;
		}
	}

	return sType;
}

function GenerateLinkHRef(form)
{
	var sUri = "";
	var sTarget = "";

	switch (form.elements["LinkType"].options[form.elements["LinkType"].selectedIndex].value)
	{
		case "url":
			sUri = $("txtUrl").value;
			if (sUri.length == 0)
			{
				alert(GetTranslation("msg-no-url"));
				return false;
			}
			sUri = $("cmbLinkProtocol").value + sUri;

			if ($("cmbTarget").value == "popup")
				sUri = BuildPopup(sUri);
			else
				sTarget = $("txtTargetFrame").value;

			break;
		case "email":
			sUri = $("txtEmailAddress").value;
			if (sUri.length == 0)
			{
				alert(GetTranslation("msg-no-email"));
				return false;
			}
			sUri = oParser.CreateEMailUri(sUri, $("txtEmailSubject").value, $("txtEmailBody").value);
			break;
		case "internal":
			sUri = $("cmbLinkInternalPage").value;
			if (sUri.length == 0)
			{
				alert(GetTranslation("msg-no-page-selected"));
				return false;
			}

			if ($("cmbTarget").value == "popup")
				sUri = BuildPopup(sUri);
			else
				sTarget = $("txtTargetFrame").value;

			break;
	}

	form.elements["Link"].value = sUri;
	form.elements["Target"].value = sTarget;

	return true;
}

function SetTarget(targetType)
{
	$('tdTargetFrame').style.display = (targetType == 'popup' || targetType == '' ? 'none' : '');
	$('tdPopupName').style.display = $('tablePopupFeatures').style.display = (targetType == 'popup' ? '' : 'none');

	switch (targetType)
	{
		case "_blank":
		case "_self":
		case "_parent":
		case "_top":
			$('txtTargetFrame').value = targetType;
			break ;
		case "":
			$('txtTargetFrame').value = '';
			break ;
	}
}

function OnUrlChange()
{
	var sUrl = $('txtUrl').value ;
	var sProtocol = oRegex.UrlOnChangeProtocol.exec(sUrl);

	if (sProtocol)
	{
		sUrl = sUrl.substr(sProtocol[0].length);
		$('txtUrl').value = sUrl;
		$('cmbLinkProtocol').value = sProtocol[0].toLowerCase();
	}
	else if (oRegex.UrlOnChangeTestOther.test(sUrl))
	{
		$('cmbLinkProtocol').value = '';
	}
}

function OnTargetNameChange()
{
	var sFrame = $('txtTargetFrame').value;

	if (sFrame.length == 0)
		$('cmbTarget').value = '';
	else if (oRegex.ReserveTarget.test(sFrame))
		$('cmbTarget').value = sFrame.toLowerCase();
	else
		$('cmbTarget').value = 'frame';
}

function FillPopupFields(windowName, features)
{
	if (windowName)
		$('txtPopupName').value = windowName;

	var oFeatures = new Object();
	var oFeaturesMatch;
	while ((oFeaturesMatch = oRegex.PopupFeatures.exec(features)) != null)
	{
		var sValue = oFeaturesMatch[2];
		if (sValue == ('yes' || '1'))
			oFeatures[oFeaturesMatch[1]] = true;
		else if (!isNaN(sValue) && sValue != 0)
			oFeatures[oFeaturesMatch[1]] = sValue;
	}

	// Update all features check boxes.
	var aChkFeatures = document.getElementsByName('chkFeature');
	for (var i = 0; i < aChkFeatures.length; i++)
	{
		if (oFeatures[aChkFeatures[i].value])
			aChkFeatures[i].checked = true;
	}

	// Update position and size text boxes.
	if (oFeatures['width']) $('txtPopupWidth').value = oFeatures['width'];
	if (oFeatures['height']) $('txtPopupHeight').value = oFeatures['height'];
	if (oFeatures['left']) $('txtPopupLeft').value = oFeatures['left'];
	if (oFeatures['top']) $('txtPopupTop').value = oFeatures['top'];
}

function BuildPopup(sUri)
{
	var sWindowName = "'" + $('txtPopupName').value.replace(/\W/gi, "") + "'" ;

	var sFeatures = '' ;
	var aChkFeatures = document.getElementsByName('chkFeature');
	for (var i = 0; i < aChkFeatures.length; i++)
	{
		if (i > 0) sFeatures += ",";
		sFeatures += aChkFeatures[i].value + "=" + (aChkFeatures[i].checked ? "yes" : "no");
	}

	if ($('txtPopupWidth').value.length > 0) sFeatures += ',width=' + $('txtPopupWidth').value;
	if ($('txtPopupHeight').value.length > 0) sFeatures += ',height=' + $('txtPopupHeight').value;
	if ($('txtPopupLeft').value.length > 0) sFeatures += ',left=' + $('txtPopupLeft').value;
	if ($('txtPopupTop').value.length > 0) sFeatures += ',top=' + $('txtPopupTop').value;

	if (sFeatures != '')
		sFeatures = sFeatures + ",status";

	return ("javascript:void(window.open('" + sUri + "'," + sWindowName + ",'" + sFeatures + "'));");
}


function ShowLinkTypeDiv(sType)
{
	var typeURL = $("divLinkTypeURL");
	var typeEmail = $("divLinkTypeEmail");
	var typeInternalPage = $("divLinkTypeInternalPage");
	var target = $("divLinkTarget");

	typeURL.style.display = "none";
	typeEmail.style.display = "none";
	typeInternalPage.style.display = "none";
	target.style.display = "none";

	switch (sType)
	{
		case "url":
			typeURL.style.display = "block";
			target.style.display = "block";
			break;
		case "email":
			typeEmail.style.display = "block";
			break;
		case "internal":
			typeInternalPage.style.display = "block";
			target.style.display = "block";
			break;
	}
}

function ChangeLinkType(elm)
{
	ShowLinkTypeDiv(elm.options[elm.selectedIndex].value);
}
