var InputFile = Class.create();
InputFile.prototype = {
	initialize: function(name)
	{
		this.btn = $(name+'-btn');
		this.file = $(name+'-file');
		Event.observe(this.btn, 'mousemove', this.moveFile.bindAsEventListener(this));
		Event.observe(this.file, 'mousemove', this.moveFile.bindAsEventListener(this));
		Event.observe($(name), 'change', this.setFile.bindAsEventListener(this));
	},

	moveFile: function(event)
	{
		var target = Event.element(event);

		var x = Event.pointerX(event) - this.getScrollLeft() - this.btn.viewportOffset().left;
		var y = Event.pointerY(event) - this.getScrollTop() - this.btn.viewportOffset().top;

		if (x > 0 && x < this.btn.offsetWidth && y > 0 && y < this.btn.offsetHeight)
		{
		/*	var newX = x - Math.round(this.file.offsetWidth/2) + this.btn.viewportOffset().left - 50 + this.getScrollLeft();
			var newY = y - Math.round(this.file.offsetHeight/2) + this.btn.viewportOffset().top - 117 + this.getScrollTop() + 90;*/
			var newX = x - Math.round(this.file.offsetWidth/2) + this.btn.viewportOffset().left - 200 + this.getScrollLeft();
			var newY = y - Math.round(this.file.offsetHeight/2) + this.btn.viewportOffset().top - 92 + this.getScrollTop() + 90;
			this.file.setStyle({visibility: 'visible', left: newX+'px', top: newY+'px'});
		}
		else
		{
			this.file.setStyle({visibility: 'hidden'});
		}
	},

	setFile: function(event)
	{
		var target = Event.element(event);
		if (target.value)
		{
			var fileName = target.value.replace(/^([^\\\/]*(\\|\/))*/, "");
			if (fileName.length > 20)
				newFileName = fileName.substr(0, 14)+'...'+fileName.substr(fileName.length-3, 3);
			else
				newFileName = fileName;
			this.btn.update(newFileName);
		}
		else
		{
			this.btn.update(this.btn.title);
		}
	},

	getScrollTop: function()
	{
		var scrollTop = 0;
		if (Prototype.Browser.Opera)
			scrollTop = 0;
		else if (window.pageYOffset)
			scrollTop = window.pageYOffset;
		else if (document.documentElement.scrollTop)
			scrollTop = document.documentElement.scrollTop;
		else if (document.body.scrollTop)
			scrollTop = document.body.scrollTop;
		return scrollTop;
	},

	getScrollLeft: function()
	{
		var scrollLeft = 0;
		if (Prototype.Browser.Opera)
			scrollLeft = 0;
		else if (window.pageXOffset)
			scrollLeft = window.pageXOffset;
		else if (document.documentElement.scrollLeft)
			scrollLeft = document.documentElement.scrollLeft;
		else if (document.body.scrollLeft)
			scrollLeft = document.body.scrollLeft;
		return scrollLeft;
	}
}

var InputImage = Class.create();
InputImage.prototype = {
	initialize: function(imageName, image, width, savedImage, itemID, removeAction, ajaxPath, pageID)
	{
		this.imageName = imageName;
		this.itemID = itemID;
		this.removeAction = removeAction;
		this.ajaxPath = ajaxPath;
		this.pageID = pageID;

		var html = $(imageName+'-box').innerHTML;
		html += '<span class="image-container" id="'+imageName+'-img"'+(image ? '' : ' style="display:none;"')+'><img src="'+image+'" alt="" width="'+(width > 260 ? 260 : width)+'" /></span>';
		html += '<a id="'+imageName+'-btn" class="change-file">'+(image ? GetTranslation('change-image') : GetTranslation('add-image'))+'</a>';
		html += '<a id="'+imageName+'-del" class="delete-file"'+(image ? '' : ' style="display:none;"')+'>'+GetTranslation('remove-image')+'</a>';
		html += '<div class="clear"></div>';
		html += '<div class="real-file" id="'+imageName+'-file"><input name="'+imageName+'" id="'+imageName+'" type="file" size="1" /></div>';
		html += '<input type="hidden" name="Saved'+imageName+'" id="Saved'+imageName+'" value="'+savedImage+'" />';
		$(imageName+'-box').update(html);

        Event.observe($(imageName+'-del'), 'click', this.removeImage.bindAsEventListener(this));

		new InputFile(imageName);
	},

	removeImage: function()
	{
		if (!confirm(GetTranslation('remove-image-confirm')))
			return;

		$(this.imageName+'-img').update('<i>'+GetTranslation('removing-image')+'</i>');

		new Ajax.Request(this.ajaxPath, {
			parameters:
			{
				'Action': this.removeAction,
				'PageID': this.pageID,
				'ItemID': this.itemID,
				'ImageName': this.imageName,
				'SavedImage': $('Saved'+this.imageName).value
			},
			onCreate: function() { $('debug').update(''); },
			onSuccess: (function(tr)
			{
				var result = tr.transport.responseJS;
				if (result)
				{
					if (result.SessionExpired)
					{
						document.location.href = 'index.php';
						return;
					}

					$(this.imageName+'-btn').update(GetTranslation('add-image'));
					$(this.imageName+'-img').hide();
					$(this.imageName+'-del').hide();
					$('Saved'+this.imageName).value = '';

					if (!result.Answer)
						alert(GetTranslation('error-removing-image'));
				}
			}).bind(this),
			onFailure: function(tr)
			{
				$('debug').update(tr.responseText);
			}
		});
	}
}
