<?php
define('IS_ADMIN', true);
require_once(dirname(__FILE__)."/../../include/init.php");
$expire = mktime(0, 0, 0, date("m")+COOKIE_EXPIRE, date("d"), date("Y"));
$expireDate = date("Y", $expire).", ".date("n", $expire).", ".date("j", $expire);
?>
var path2Admin = "<?php echo ADMIN_PATH; ?>";

var PageEdit = Class.create();

PageEdit.prototype = {
	initialize: function(form, type, menuList, menuImagesCount)
	{
		this.path2Admin = '<?php echo ADMIN_PATH; ?>';
		this.ajaxBusy = false;
		this.form = form;
		this.type = type;
		this.menuList = menuList;
		this.menuImagesCount = menuImagesCount;

		var elmList = form.getElements().findAll((function(s)
		{
			if (s.tagName == 'SELECT' && s.name.substr(0, 6) == 'Select')
				return true;
			else
				return false;
		}));

		for (var i = 0; i < elmList.length; i++)
		{
			Event.observe(elmList[i], 'change', this.parseEvent.bindAsEventListener(this));
			if (i == elmList.length - 1)
			{
				// Show/hide menu images
				this.toggleMenuImages(elmList[i]);
			}
		}
	},

	getID: function(elm)
	{
		return parseInt(elm.name.substr(6));
	},

	parseEvent: function(event)
	{
		if (this.ajaxBusy) return;

		var target = Event.element(event);
		target.disabled = true;
		var sID = cID = this.getID(target);
		$('ParentID').value = 0;

		if (target.selectedIndex == 0)
			cID = sID - 1;

		// Update Page URL
		var parentURL = $('ParentURL');
		if (parentURL)
		{
			if (cID < 1)
			{
				parentURL.update('');
			}
			else
			{
				var pathChunks = parentURL.innerHTML.split('/');
				if (pathChunks.length > cID)
				{
					var newParentURL = '';
					if (target.selectedIndex == 0)
						var upTo = cID;
					else
						var upTo = cID - 1;
					for (i = 0; i < upTo; i++)
					{
						newParentURL = newParentURL + pathChunks[i] + '/';
					}
					parentURL.update(newParentURL);
				}
			}
		}

		// Find which select boxes to remove
		var toRemove = new Array();
		var dropDowns = target.up(0).childElements();
		this.newSelect = null;
		for (var i = 0; i < dropDowns.length; i++)
		{
			if (dropDowns[i].tagName == 'SELECT' && this.getID(dropDowns[i]) > cID)
			{
				if (this.getID(dropDowns[i]) == cID + 1)
				{
					this.newSelect = dropDowns[i];
					this.newSelect.selectedIndex = 0;
				}
				else
				{
					toRemove[toRemove.length] = dropDowns[i];
				}
			}
			else if (dropDowns[i].tagName == 'SELECT')
			{
				$('ParentID').value = dropDowns[i].value;
			}
		}

		for (i = toRemove.length - 1; i > -1; i--)
		{
			toRemove[i].up(0).removeChild(toRemove[i]);
		}

		// Show/hide menu images
		this.toggleMenuImages(target);

		if (target.selectedIndex == 0)
		{
			target.disabled = false;
			window.focus();
			target.focus();
			return;
		}

		this.ajaxBusy = true;

		new Ajax.Request(this.path2Admin+'ajax.php', {
			parameters:
			{
				'Action': 'GetChildren',
				'Type': this.type,
				'PageID': target.value
			},
			onCreate: function() { $('debug').update(''); },
			onSuccess: function(tr)
			{
				var result = tr.transport.responseJS;
				if (result)
				{
					if (result.SessionExpired)
					{
						document.location.href = 'index.php';
						return;
					}

					if (!this.newSelect && result.PageList && result.PageList.length > 0)
					{
						this.newSelect = document.createElement('SELECT');
						this.newSelect.name = 'Select'+(sID+1);
						this.newSelect.className = 'fw150';
						Event.observe(this.newSelect, 'change', this.parseEvent.bindAsEventListener(this));
						this.newSelect.options[this.newSelect.options.length] = new Option('...', '');
						target.up(0).appendChild(this.newSelect);
					}

					if (result.StaticPath && cID > 0 && parentURL)
					{
						parentURL.update(parentURL.innerHTML + result.StaticPath + '/');
						if ($('StaticPath').value == 'index')
							parentURL.hide();
						else
							parentURL.show();
					}

					if (result.PageList && result.PageList.length > 0)
					{
						// Clear list of pages
						for (var i = this.newSelect.options.length - 1; i > 0; i--)
						{
							this.newSelect.remove(i);
						}
						// Fill list of pages
						for (var i = 0; i < result.PageList.length; i++)
						{
							if (parseInt(result.PageList[i]['PageID']) == parseInt($('PageID').value))
								continue;
							this.newSelect.options[this.newSelect.options.length] = new Option(result.PageList[i]['Title'], result.PageList[i]['PageID']);
						}
						if (this.newSelect.options.length == 1)
						{
							this.newSelect.up(0).removeChild(this.newSelect);
						}
					}
					else if (this.newSelect)
					{
						this.newSelect.up(0).removeChild(this.newSelect);
					}

					target.disabled = false;
					window.focus();
					target.focus();
				}
				this.ajaxBusy = false;
			}.bind(this),
			onFailure: function(tr)
			{
				$('debug').update(tr.responseText);
				this.ajaxBusy = false;
			}.bind(this)
		});
	},

	toggleMenuImages: function(target)
	{
		var hide = true;
		if ($('Select0').value > 0)
		{
			for (var i = 0; i < this.menuList[$('Select0').value].length; i++)
			{
				var num = this.menuList[$('Select0').value][i]['key'];
				switch (this.menuList[$('Select0').value][i]['val'])
				{
					case '2':
						$('MenuImage'+num+'-box').show();
						hide = false;
						break;
					case '1':
						if (this.getID(target) == 0 || (this.getID(target) == 1 && target.value == 0))
						{
							$('MenuImage'+num+'-box').show();
							hide = false;
						}
						else
						{
							$('MenuImage'+num+'-box').hide();
						}
						break;
					default:
						$('MenuImage'+num+'-box').hide();
						break;
				}
			}
		}
		else
		{
			for (i = 1; i < this.menuImagesCount + 1; i++)
			{
				$('MenuImage'+i+'-box').hide();
			}
		}

		if ($('menu-image-empty'))
		{
			if (hide) $('menu-image-empty').show();
			else $('menu-image-empty').hide();
		}
	}
}
