<?php
define('IS_ADMIN', true);
require_once(dirname(__FILE__)."/../../include/init.php");
?>
// Creates new window from link
// Parameters:
// Link - link to show in window
// Effect:
// Opens a window with name "Additional" and shows needed link in it.
function linkWindow(linkURL)
{
	if (window.event)
	{
		event.cancelBubble = true;
		event.returnValue = false;
	}
	var width = Math.ceil(screen.width/2);
	var height = Math.ceil(screen.height*0.6);
	if (width < 600) width = 600;
	if (height < 400) height = 400;
	var left = Math.ceil(screen.width/4);
	var top = Math.ceil(screen.height*0.1);
	var oTarget = window.open(linkURL, "Additional", "height="+height+",width="+width+",scrollbars=1,left="+left+",top="+top);
	oTarget.focus();
	return false;
}

// Function to check all checkboxes of the form with predefined name
function checkAll(elm, name)
{
	for (i = 0; i < elm.form.elements.length; i++)
	{
		if (elm.form.elements[i].type == "checkbox" && elm.form.elements[i].name == name)
		{
			elm.form.elements[i].checked = elm.checked;
		}
	}
}

function getAbsolutePos(el)
{
	var SL = 0, ST = 0;
	var is_div = /^div$/i.test(el.tagName);
	if (is_div && el.scrollLeft)
		SL = el.scrollLeft;
	if (is_div && el.scrollTop)
		ST = el.scrollTop;
	var r = { x: el.offsetLeft - SL, y: el.offsetTop - ST };
	if (el.offsetParent)
	{
		var tmp = getAbsolutePos(el.offsetParent);
		r.x += tmp.x;
		r.y += tmp.y;
	}
	return r;
}

function createFCK(name, toolbarSet, width, height)
{
	// Create instance of FCKeditor
	var oFCKeditor = new FCKeditor(name);
	// Path to FCKeditor
	oFCKeditor.BasePath = '<?php echo FCKEDITOR_PATH; ?>';
	oFCKeditor.Width = width || '100%';
	oFCKeditor.Height = height || '500';

	// Custom configuration
	oFCKeditor.Config['CustomConfigurationsPath'] = '<?php echo PROJECT_PATH; ?>website/<?php echo WEBSITE_FOLDER; ?>/fckconfig/fckconfig.js';
	oFCKeditor.Config['EditorAreaCSS'] = '<?php echo PROJECT_PATH; ?>website/<?php echo WEBSITE_FOLDER; ?>/fckconfig/fck_editorarea.css';

	// Set language
	oFCKeditor.Config['AutoDetectLanguage'] = false;
	oFCKeditor.Config['DefaultLanguage'] = '<?php echo INTERFACE_LANGCODE; ?>';
	oFCKeditor.Config['LanguagePath'] = '<?php echo PROJECT_PATH; ?>language/<?php echo INTERFACE_LANGCODE; ?>/fckeditor/';

	// Use site manager toolbar
	oFCKeditor.ToolbarSet = toolbarSet || 'SiteManager';

	// Show FCKeditor
	oFCKeditor.ReplaceTextarea();

	return oFCKeditor;
}

var CustomSelect = Class.create();

CustomSelect.prototype = {
	initialize: function(name)
	{
		if (!($(name))) return;
		this.name = name;
		Event.observe(document, 'click', this.toggle.bindAsEventListener(this));
		Event.observe(document, 'keyup', this.close.bindAsEventListener(this));
	},

	toggle: function(event)
	{
		var target = Event.element(event);
		if (target.id == this.name+'Control')
		{
			event.stop();
			if ($(this.name).getStyle('display') == 'block')
				$(this.name).setStyle({display: 'none'});
			else
				$(this.name).setStyle({display: 'block'});
		}
		else
		{
			$(this.name).setStyle({display: 'none'});
		}
	},

	close: function(event)
	{
		if (event.keyCode == 27)
			$(this.name).setStyle({display: 'none'});
	}
}

document.observe('dom:loaded', function()
{
	new CustomSelect('WebsiteList');
	new CustomSelect('LanguageList');
});

function preventSelection(element)
{
	var preventSelection = false;

	function addHandler(element, event, handler)
	{
		if (element.attachEvent)
			element.attachEvent('on' + event, handler);
		else if (element.addEventListener)
			element.addEventListener(event, handler, false);
	}

	function removeSelection()
	{
		if (window.getSelection)
			window.getSelection().removeAllRanges();
		else if (document.selection && document.selection.clear)
			document.selection.clear(); // or empty?
	}

	function killCtrlA(event)
	{
		var event = event || window.event;
		var sender = event.target || event.srcElement;

		if (sender.tagName.match(/INPUT|TEXTAREA/i))
			return;

		var key = event.keyCode || event.which;
		if (event.ctrlKey && key == 'A'.charCodeAt(0))
		{
			removeSelection();
			if (event.preventDefault)
				event.preventDefault();
			else
				event.returnValue = false;
		}
	}

	// Do not allow to select text with mouse
	addHandler(element, 'mousemove', function()
	{
		if (preventSelection) removeSelection();
	});

	addHandler(element, 'mousedown', function(event)
	{
		var event = event || window.event;
		var sender = event.target || event.srcElement;
		preventSelection = !sender.tagName.match(/INPUT|TEXTAREA/i);
	});

	// avoid dblckick
	addHandler(element, 'mouseup', function()
	{
		if (preventSelection) removeSelection();
		preventSelection = false;
	});

	// avoid CTRL+A
	addHandler(element, 'keydown', killCtrlA);
	addHandler(element, 'keyup', killCtrlA);
}

function switchTab(tab)
{
	switch(tab)
	{
		case 1:
			$('tab-1').className = 'active';
			$('tab-2').className = 'past-active';
			$('tab-3').className = 'last';
			$('content-2').hide();
			$('content-3').hide();
			$('content-1').show();
			break;
		case 2:
			$('tab-1').className = 'first';
			$('tab-2').className = 'active';
			$('tab-3').className = 'past-active-last';
			$('content-1').hide();
			$('content-3').hide();
			$('content-2').show();
			break;
		case 3:
			$('tab-1').className = 'first';
			$('tab-2').className = '';
			$('tab-3').className = 'active-last';
			$('content-1').hide();
			$('content-2').hide();
			$('content-3').show();
			break;
	}
}

function switchTab2(tab)
{
	switch(tab)
	{
		case 1:
			$('tab-1').className = 'active';
			$('tab-2').className = 'past-active-last';
			$('content-2').hide();
			$('content-1').show();
			break;
		case 2:
			$('tab-1').className = 'first';
			$('tab-2').className = 'active-last';
			$('content-1').hide();
			$('content-2').show();
			break;
	}
}