<?php

define("IS_ADMIN", true);
require_once(dirname(__FILE__)."/../include/init.php");
es_include("localpage.php");
es_include("page.php");
es_include("pagelist.php");
es_include("js_http_request/JsHttpRequest.php");
es_include("user.php");

$language = GetLanguage();

$JsHttpRequest = new JsHttpRequest($language->GetHTMLCharset());

$user = new User();
if (!$user->LoadBySession() || !$user->Validate(array(INTEGRATOR, ADMINISTRATOR, MODERATOR)))
{
	$_RESULT["SessionExpired"] = GetTranslation("your-session-expired");
	exit();
}

$post = new LocalObject(array_merge($_GET, $_POST));
switch ($post->GetProperty("Action"))
{
	case "LoadSEO":
		$page = new Page();
		$_RESULT["Answer"] = $page->GetSEO($post->GetProperty("PageID"));
		break;

	case "SaveSEO":
		$page = new Page();
		$page->LoadFromObject($post);
		$_RESULT["Answer"] = $page->SaveSEO();
		break;

	case "LoadMenu":
		$page = new Page();
		if ($page->LoadByID($post->GetProperty("PageID")))
		{
			$page->SetProperty("MenuImages", $page->GetMenuImages());
			$_RESULT["Answer"] = $page->GetProperties();
		}
		else
		{
			$_RESULT["Answer"] = array("Title" => "", "Description" => "", "StaticPath" => "", "MenuImages" => $page->GetMenuImages());
		}
		break;

	case "SaveMenu":
		$page = new Page();

		$fields = array('PageID', 'Title', 'Description', 'StaticPath', 'Active', 'Type', 'LanguageCode');
		for ($i = 0; $i < count($page->params); $i++)
		{
			$fields[] = $page->params[$i]['Name'];
		}
		$post->SetProperty('Type', 0);
		$page->LoadFromObject($post, $fields);

		if ($page->Save())
		{
			$_RESULT["Answer"] = array('PageID' => $page->GetProperty('PageID'), 'Title' => $page->GetProperty('Title'), 'ShortTitle' => SmallString($page->GetProperty('Title'), 15));
		}
		else
		{
			$_RESULT["Error"] = $page->GetErrorsAsString();
		}
		break;

	case "Remove":
		$page = new Page();
		$page->Remove($post->GetIntProperty("PageID"));
		$_RESULT["Answer"] = "Done";
		break;

	case "SwitchActive":
		$page = new Page();
		$page->SwitchActive($post->GetIntProperty("PageID"), $post->GetProperty("Active"));
		$_RESULT["Answer"] = "Done";
		break;

	case "SaveSort":
		$pageList = new PageList();
		$_RESULT["Answer"] = $pageList->SaveSort($post->GetProperty('ParentID'), $post->GetProperty('IDs'));
		break;

	case "RemoveMenuImage":
		$stmt = GetStatement();

		if ($post->GetProperty('SavedImage'))
		{
			@unlink(MENU_IMAGE_DIR.$post->GetProperty('SavedImage'));
		}

		if ($post->GetIntProperty('ItemID') > 0 && preg_match("/^MenuImage([0-9]+)$/", $post->GetProperty('ImageName')))
		{
			$imageFile = $stmt->FetchField("SELECT ".$post->GetProperty('ImageName')."
				FROM `page` WHERE PageID=".$post->GetIntProperty('ItemID'));

			if ($imageFile) @unlink(MENU_IMAGE_DIR.$imageFile);

			$query = "UPDATE `page`
				SET ".$post->GetProperty('ImageName')."=NULL,
				".$post->GetProperty('ImageName')."Width=0,
				".$post->GetProperty('ImageName')."Height=0
				WHERE WebsiteID=".intval(WEBSITE_ID)." AND PageID=".$post->GetIntProperty('ItemID');
			$stmt->Execute($query);
		}
		$_RESULT["Answer"] = "Done";
		break;

	case "GetChildren":
		$page = new Page();
		if (!$page->LoadByID($post->GetProperty("PageID")))
		{
			$page->SetProperty("LanguageCode", $post->GetProperty("LanguageCode"));
		}
		$_RESULT["StaticPath"] = $page->GetProperty("StaticPath");
		$_RESULT["PageList"] = $page->GetChildren($post->GetProperty("Type"));
		break;

	case "SaveVariableToXML":
		if ($post->GetProperty('Type') != 'php')
			$type = 'template';
		else
			$type = 'php';

		$data = $language->GetXML($post->GetProperty('Module'), $type);
		if ($type == 'template')
		{
			if (isset($data[$post->GetProperty('Type')][$post->GetProperty('Template')][$post->GetProperty('TagName')]))
			{
				$data[$post->GetProperty('Type')][$post->GetProperty('Template')][$post->GetProperty('TagName')] = $post->GetProperty('VariableValue');
				$language->SaveXML($post->GetProperty('Module'), $type, $data);
			}
		}
		else
		{
			if (isset($data[$post->GetProperty('TagName')]))
			{
				$data[$post->GetProperty('TagName')] = $post->GetProperty('VariableValue');
				$language->SaveXML($post->GetProperty('Module'), $type, $data);
			}
		}

		$_RESULT["Answer"] = htmlspecialchars($post->GetProperty('VariableValue', ENT_QUOTES));
		break;

	default:
		$_RESULT["Answer"] = "";
		break;
}

?>